/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.event.Event;
import cucumber.api.event.EventHandler;
import cucumber.runner.AbstractEventBus;
import cucumber.runner.EventBus;
import cucumber.runner.Runner;
import cucumber.runner.RunnerSupplier;
import cucumber.runtime.BackendSupplier;
import io.cucumber.core.options.RunnerOptions;

public class ThreadLocalRunnerSupplier
implements RunnerSupplier {
    private final BackendSupplier backendSupplier;
    private final RunnerOptions runnerOptions;
    private final SynchronizedEventBus sharedEventBus;
    private final ThreadLocal<Runner> runners = new ThreadLocal<Runner>(){

        @Override
        protected Runner initialValue() {
            return ThreadLocalRunnerSupplier.this.createRunner();
        }
    };

    public ThreadLocalRunnerSupplier(RunnerOptions runnerOptions, EventBus sharedEventBus, BackendSupplier backendSupplier) {
        this.runnerOptions = runnerOptions;
        this.sharedEventBus = SynchronizedEventBus.synchronize(sharedEventBus);
        this.backendSupplier = backendSupplier;
    }

    @Override
    public Runner get() {
        return this.runners.get();
    }

    private Runner createRunner() {
        return new Runner(new LocalEventBus(this.sharedEventBus), this.backendSupplier.get(), this.runnerOptions);
    }

    private static final class SynchronizedEventBus
    implements EventBus {
        private final EventBus delegate;

        static SynchronizedEventBus synchronize(EventBus eventBus) {
            if (eventBus instanceof SynchronizedEventBus) {
                return (SynchronizedEventBus)eventBus;
            }
            return new SynchronizedEventBus(eventBus);
        }

        private SynchronizedEventBus(EventBus delegate) {
            this.delegate = delegate;
        }

        @Override
        public synchronized Long getTime() {
            return this.delegate.getTime();
        }

        @Override
        public synchronized void send(Event event) {
            this.delegate.send(event);
        }

        @Override
        public synchronized void sendAll(Iterable<Event> events) {
            this.delegate.sendAll(events);
        }

        @Override
        public synchronized <T extends Event> void registerHandlerFor(Class<T> eventType, EventHandler<T> handler) {
            this.delegate.registerHandlerFor(eventType, handler);
        }

        @Override
        public synchronized <T extends Event> void removeHandlerFor(Class<T> eventType, EventHandler<T> handler) {
            this.delegate.removeHandlerFor(eventType, handler);
        }

        @Override
        public Long getTimeMillis() {
            return this.delegate.getTimeMillis();
        }
    }

    private static final class LocalEventBus
    extends AbstractEventBus {
        private final SynchronizedEventBus parent;

        LocalEventBus(SynchronizedEventBus parent) {
            this.parent = parent;
        }

        @Override
        public Long getTime() {
            return this.parent.getTime();
        }

        @Override
        public void send(Event event) {
            super.send(event);
            this.parent.send(event);
        }

        @Override
        public Long getTimeMillis() {
            return this.parent.getTimeMillis();
        }
    }
}

