/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.filter;

import cucumber.runtime.filter.PicklePredicate;
import cucumber.runtime.filter.TagExpressionOld;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleTag;
import io.cucumber.tagexpressions.Expression;
import io.cucumber.tagexpressions.TagExpressionParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class TagPredicate
implements PicklePredicate {
    private final List<Expression> expressions = new ArrayList<Expression>();
    private final List<TagExpressionOld> oldStyleExpressions = new ArrayList<TagExpressionOld>();

    public TagPredicate(List<String> tagExpressions) {
        if (tagExpressions == null) {
            return;
        }
        TagExpressionParser parser = new TagExpressionParser();
        for (String tagExpression : tagExpressions) {
            if (TagExpressionOld.isOldTagExpression(tagExpression)) {
                this.oldStyleExpressions.add(new TagExpressionOld(Arrays.asList(tagExpression)));
                continue;
            }
            this.expressions.add(parser.parse(tagExpression));
        }
    }

    @Override
    public boolean apply(PickleEvent pickleEvent) {
        return this.apply(pickleEvent.pickle.getTags());
    }

    public boolean apply(Collection<PickleTag> pickleTags) {
        for (TagExpressionOld oldStyleExpression : this.oldStyleExpressions) {
            if (oldStyleExpression.evaluate(pickleTags)) continue;
            return false;
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (PickleTag pickleTag : pickleTags) {
            tags.add(pickleTag.getName());
        }
        for (Expression expression : this.expressions) {
            if (expression.evaluate(tags)) continue;
            return false;
        }
        return true;
    }
}

