/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.feature.FeatureWithLines;
import io.cucumber.core.plugin.NiceAppendable;
import io.cucumber.core.plugin.PrettyFormatter;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class RerunFormatter
implements ConcurrentEventListener {
    private final NiceAppendable out;
    private final Map<URI, Collection<Integer>> featureAndFailedLinesMapping = new HashMap<URI, Collection<Integer>>();

    public RerunFormatter(OutputStream out) {
        this.out = new NiceAppendable(new UTF8OutputStreamWriter(out));
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, event -> this.finishReport());
    }

    private void handleTestCaseFinished(TestCaseFinished event) {
        if (!event.getResult().getStatus().isOk()) {
            this.recordTestFailed(event.getTestCase());
        }
    }

    private void finishReport() {
        for (Map.Entry<URI, Collection<Integer>> entry : this.featureAndFailedLinesMapping.entrySet()) {
            FeatureWithLines featureWithLines = FeatureWithLines.create(PrettyFormatter.relativize(entry.getKey()), entry.getValue());
            this.out.println(featureWithLines.toString());
        }
        this.out.close();
    }

    private void recordTestFailed(TestCase testCase) {
        URI uri = testCase.getUri();
        Collection<Integer> failedTestCaseLines = this.getFailedTestCaseLines(uri);
        failedTestCaseLines.add(testCase.getLocation().getLine());
    }

    private Collection<Integer> getFailedTestCaseLines(URI uri) {
        return this.featureAndFailedLinesMapping.computeIfAbsent(uri, k -> new ArrayList());
    }
}

