/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.options.CucumberProperties;
import io.cucumber.core.options.CurlOption;
import io.cucumber.core.plugin.MessageFormatter;
import io.cucumber.core.plugin.UrlOutputStream;
import io.cucumber.core.plugin.UrlReporter;
import io.cucumber.plugin.ColorAware;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.IOException;
import java.util.Map;

public final class PublishFormatter
implements ConcurrentEventListener,
ColorAware {
    public static final String DEFAULT_CUCUMBER_MESSAGE_STORE_URL = "https://messages.cucumber.io/api/reports -X GET";
    private final UrlReporter urlReporter = new UrlReporter(System.err);
    private final MessageFormatter delegate;

    public PublishFormatter() throws IOException {
        this(PublishFormatter.createCurlOption(null));
    }

    public PublishFormatter(String token) throws IOException {
        this(PublishFormatter.createCurlOption(token));
    }

    private PublishFormatter(CurlOption curlOption) throws IOException {
        UrlOutputStream outputStream = new UrlOutputStream(curlOption, this.urlReporter);
        this.delegate = new MessageFormatter(outputStream);
    }

    public void setEventPublisher(EventPublisher publisher) {
        this.delegate.setEventPublisher(publisher);
    }

    public void setMonochrome(boolean monochrome) {
        this.urlReporter.setMonochrome(monochrome);
    }

    private static CurlOption createCurlOption(String token) {
        String proxy;
        Map<String, String> properties = CucumberProperties.create();
        String url = properties.getOrDefault("cucumber.publish.url", DEFAULT_CUCUMBER_MESSAGE_STORE_URL);
        if (token != null) {
            url = url + String.format(" -H 'Authorization: Bearer %s'", token);
        }
        if ((proxy = properties.get("cucumber.publish.proxy")) != null) {
            url = url + String.format(" -x '%s'", proxy);
        }
        return CurlOption.parse(url);
    }
}

