/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.eventbus;

import io.cucumber.core.eventbus.UuidGenerator;
import io.cucumber.core.exception.CucumberException;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

public class IncrementingUuidGenerator
implements UuidGenerator {
    private static final long MAX_EPOCH_TIME = 0xFFFFFFFFFFL;
    static final long MAX_SESSION_ID = 255L;
    static final long MAX_COUNTER_VALUE = 0x3FFFFFFFFFFFFFFFL;
    static long classloaderId = new Random().nextInt() & 0xFFF;
    static final AtomicLong sessionCounter = new AtomicLong(-1L);
    final long msb;
    final AtomicLong counter = new AtomicLong(-1L);

    public static void setClassloaderId(int classloaderId) {
        IncrementingUuidGenerator.classloaderId = classloaderId & 0xFFF;
    }

    public IncrementingUuidGenerator() {
        long sessionId = sessionCounter.incrementAndGet();
        if (sessionId == 255L) {
            throw new CucumberException("Out of " + IncrementingUuidGenerator.class.getSimpleName() + " capacity. Please reuse existing instances or use another " + UuidGenerator.class.getSimpleName() + " implementation instead.");
        }
        long epochTime = System.currentTimeMillis();
        this.msb = (epochTime & 0xFFFFFFFFFFL) << 24 | sessionId << 16 | 0x8000L | classloaderId;
    }

    @Override
    public UUID generateId() {
        long counterValue = this.counter.incrementAndGet();
        if (counterValue == 0x3FFFFFFFFFFFFFFFL) {
            throw new CucumberException("Out of " + IncrementingUuidGenerator.class.getSimpleName() + " capacity. Please generate using a new instance or use another " + UuidGenerator.class.getSimpleName() + "implementation.");
        }
        long leastSigBits = counterValue | Long.MIN_VALUE;
        return new UUID(this.msb, leastSigBits);
    }
}

