/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.gherkin;

import io.cucumber.gherkin.Gherkin;
import io.cucumber.gherkin.GherkinException;
import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.MessageToNdjsonWriter;
import io.cucumber.messages.MessageWriter;
import io.cucumber.messages.types.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;

public class Main {
    public static void main(String[] argv) {
        ArrayList<String> args = new ArrayList<String>(Arrays.asList(argv));
        ArrayList<String> paths = new ArrayList<String>();
        boolean includeSource = true;
        boolean includeAst = true;
        boolean includePickles = true;
        IdGenerator.UUID idGenerator = null;
        block12: while (!args.isEmpty()) {
            String arg;
            switch (arg = ((String)args.remove(0)).trim()) {
                case "--no-source": {
                    includeSource = false;
                    continue block12;
                }
                case "--no-ast": {
                    includeAst = false;
                    continue block12;
                }
                case "--no-pickles": {
                    includePickles = false;
                    continue block12;
                }
                case "--predictable-ids": {
                    idGenerator = new IdGenerator.Incrementing();
                    continue block12;
                }
            }
            paths.add(arg);
        }
        if (idGenerator == null) {
            idGenerator = new IdGenerator.UUID();
        }
        MessageWriter messageWriter = Main.makeMessageWriter();
        Stream<Envelope> messages = Gherkin.fromPaths(paths, includeSource, includeAst, includePickles, (IdGenerator)idGenerator);
        Main.printMessages(messageWriter, messages);
    }

    private static void printMessages(MessageWriter messageWriter, Stream<Envelope> messages) {
        messages.forEach(envelope -> {
            try {
                messageWriter.write(envelope);
            }
            catch (IOException e) {
                throw new GherkinException("Couldn't print messages", e);
            }
        });
    }

    private static MessageWriter makeMessageWriter() {
        return new MessageToNdjsonWriter((OutputStream)System.out);
    }
}

