/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.options;

import io.cucumber.core.feature.FeatureWithLines;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

class RerunPath {
    RerunPath() {
    }

    static Collection<FeatureWithLines> parse(Path rerunFileOrDirectory) {
        return RerunPath.listRerunFiles(rerunFileOrDirectory).stream().map(FeatureWithLines::parseFile).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private static Set<Path> listRerunFiles(Path path) {
        try {
            class FileCollector
            extends SimpleFileVisitor<Path> {
                final Set<Path> paths = new HashSet<Path>();

                FileCollector() {
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (!Files.isDirectory(file, new LinkOption[0])) {
                        this.paths.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            }
            FileCollector collector = new FileCollector();
            Files.walkFileTree(path, collector);
            return collector.paths;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

