/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.CombinatorialGeneratedExpressionFactory;
import io.cucumber.cucumberexpressions.GeneratedExpression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeMatcher;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CucumberExpressionGenerator {
    private final ParameterTypeRegistry parameterTypeRegistry;

    public CucumberExpressionGenerator(ParameterTypeRegistry parameterTypeRegistry) {
        this.parameterTypeRegistry = parameterTypeRegistry;
    }

    public List<GeneratedExpression> generateExpressions(String text) {
        ParameterTypeMatcher bestParameterTypeMatcher;
        ArrayList parameterTypeCombinations = new ArrayList();
        List<ParameterTypeMatcher> parameterTypeMatchers = this.createParameterTypeMatchers(text);
        StringBuilder expressionTemplate = new StringBuilder();
        int pos = 0;
        do {
            ArrayList<ParameterTypeMatcher> matchingParameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
            for (ParameterTypeMatcher parameterTypeMatcher : parameterTypeMatchers) {
                ParameterTypeMatcher advancedParameterTypeMatcher = parameterTypeMatcher.advanceTo(pos);
                if (!advancedParameterTypeMatcher.find()) continue;
                matchingParameterTypeMatchers.add(advancedParameterTypeMatcher);
            }
            if (matchingParameterTypeMatchers.isEmpty()) break;
            Collections.sort(matchingParameterTypeMatchers);
            bestParameterTypeMatcher = (ParameterTypeMatcher)matchingParameterTypeMatchers.get(0);
            ArrayList<ParameterTypeMatcher> bestParameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
            for (ParameterTypeMatcher m : matchingParameterTypeMatchers) {
                if (m.compareTo(bestParameterTypeMatcher) != 0) continue;
                bestParameterTypeMatchers.add(m);
            }
            TreeSet parameterTypes = new TreeSet();
            HashSet set = new HashSet();
            for (ParameterTypeMatcher parameterTypeMatcher : bestParameterTypeMatchers) {
                ParameterType<?> parameterType = parameterTypeMatcher.getParameterType();
                set.add(parameterType);
            }
            parameterTypes.addAll(set);
            parameterTypeCombinations.add(new ArrayList(parameterTypes));
            expressionTemplate.append(this.escape(text.substring(pos, bestParameterTypeMatcher.start()))).append("{%s}");
        } while ((pos = bestParameterTypeMatcher.start() + bestParameterTypeMatcher.group().length()) < text.length());
        expressionTemplate.append(this.escape(text.substring(pos)));
        return new CombinatorialGeneratedExpressionFactory(expressionTemplate.toString(), parameterTypeCombinations).generateExpressions();
    }

    private String escape(String s) {
        return s.replaceAll("%", "%%").replaceAll("\\(", "\\\\(").replaceAll("\\{", "\\\\{").replaceAll("/", "\\\\/");
    }

    @Deprecated
    public GeneratedExpression generateExpression(String text) {
        List<GeneratedExpression> generatedExpressions = this.generateExpressions(text);
        return generatedExpressions.get(0);
    }

    private List<ParameterTypeMatcher> createParameterTypeMatchers(String text) {
        Collection<ParameterType<?>> parameterTypes = this.parameterTypeRegistry.getParameterTypes();
        ArrayList<ParameterTypeMatcher> parameterTypeMatchers = new ArrayList<ParameterTypeMatcher>();
        for (ParameterType<?> parameterType : parameterTypes) {
            if (!parameterType.useForSnippets()) continue;
            parameterTypeMatchers.addAll(CucumberExpressionGenerator.createParameterTypeMatchers(parameterType, text));
        }
        return parameterTypeMatchers;
    }

    private static List<ParameterTypeMatcher> createParameterTypeMatchers(ParameterType<?> parameterType, String text) {
        ArrayList<ParameterTypeMatcher> result = new ArrayList<ParameterTypeMatcher>();
        List<String> captureGroupRegexps = parameterType.getRegexps();
        for (String captureGroupRegexp : captureGroupRegexps) {
            Pattern regexp = Pattern.compile("(" + captureGroupRegexp + ")");
            Matcher matcher = regexp.matcher(text);
            result.add(new ParameterTypeMatcher(parameterType, matcher, text.length()));
        }
        return result;
    }
}

