/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.gherkin.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.gherkin.Pickle;
import io.cucumber.core.gherkin.messages.CucumberQuery;
import io.cucumber.core.gherkin.messages.GherkinMessagesFeature;
import io.cucumber.core.gherkin.messages.GherkinMessagesPickle;
import io.cucumber.core.gherkin.messages.internal.gherkin.Gherkin;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialect;
import io.cucumber.core.gherkin.messages.internal.gherkin.GherkinDialectProvider;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.ParseError;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GherkinMessagesFeatureParser
implements FeatureParser {
    public Optional<Feature> parse(URI path, String source, Supplier<UUID> idGenerator) {
        List<Envelope> sources = Collections.singletonList(Gherkin.makeSourceEnvelope(source, path.toString()));
        List<Envelope> envelopes = Gherkin.fromSources(sources, true, true, true, () -> ((UUID)idGenerator.get()).toString()).collect(Collectors.toList());
        GherkinDocument gherkinDocument = envelopes.stream().map(Envelope::getGherkinDocument).filter(Objects::nonNull).findFirst().orElse(null);
        if (gherkinDocument == null || gherkinDocument.getFeature() == null) {
            List errors = envelopes.stream().map(Envelope::getParseError).filter(Objects::nonNull).map(ParseError::getMessage).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                throw new FeatureParserException("Failed to parse resource at: " + path + "\n" + String.join((CharSequence)"\n", errors));
            }
            return Optional.empty();
        }
        CucumberQuery cucumberQuery = new CucumberQuery();
        cucumberQuery.update(gherkinDocument);
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        io.cucumber.messages.types.Feature feature = gherkinDocument.getFeature();
        String language = feature.getLanguage();
        GherkinDialect dialect = dialectProvider.getDialect(language, null);
        List pickleMessages = envelopes.stream().map(Envelope::getPickle).filter(Objects::nonNull).collect(Collectors.toList());
        List<Pickle> pickles = pickleMessages.stream().map(pickle -> new GherkinMessagesPickle((io.cucumber.messages.types.Pickle)pickle, path, dialect, cucumberQuery)).collect(Collectors.toList());
        GherkinMessagesFeature messagesFeature = new GherkinMessagesFeature(feature, path, source, pickles, envelopes);
        return Optional.of(messagesFeature);
    }

    public String version() {
        return "8";
    }
}

