/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages.internal.gherkin.pickles;

import io.cucumber.messages.IdGenerator;
import io.cucumber.messages.types.DataTable;
import io.cucumber.messages.types.DocString;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleDocString;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.PickleStepArgument;
import io.cucumber.messages.types.PickleTable;
import io.cucumber.messages.types.PickleTableCell;
import io.cucumber.messages.types.PickleTableRow;
import io.cucumber.messages.types.PickleTag;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.messages.types.Tag;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PickleCompiler {
    private final IdGenerator idGenerator;

    public PickleCompiler(IdGenerator idGenerator) {
        this.idGenerator = idGenerator;
    }

    public List<Pickle> compile(GherkinDocument gherkinDocument, String uri) {
        ArrayList<Pickle> pickles = new ArrayList<Pickle>();
        Feature feature = gherkinDocument.getFeature();
        if (feature == null) {
            return pickles;
        }
        String language = feature.getLanguage();
        this.compileFeature(pickles, feature, language, uri);
        return pickles;
    }

    private void compileFeature(List<Pickle> pickles, Feature feature, String language, String uri) {
        List tags = feature.getTags();
        ArrayList<Step> featureBackgroundSteps = new ArrayList<Step>();
        for (FeatureChild featureChild : feature.getChildren()) {
            if (featureChild.getBackground() != null) {
                featureBackgroundSteps.addAll(featureChild.getBackground().getSteps());
                continue;
            }
            if (featureChild.getRule() != null) {
                this.compileRule(pickles, featureChild.getRule(), tags, featureBackgroundSteps, language, uri);
                continue;
            }
            Scenario scenario = featureChild.getScenario();
            if (scenario.getExamples().isEmpty()) {
                this.compileScenario(pickles, scenario, tags, featureBackgroundSteps, language, uri);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, tags, featureBackgroundSteps, language, uri);
        }
    }

    private void compileRule(List<Pickle> pickles, Rule rule, List<Tag> parentTags, List<Step> featureBackgroundSteps, String language, String uri) {
        ArrayList<Step> ruleBackgroundSteps = new ArrayList<Step>(featureBackgroundSteps);
        ArrayList<Tag> ruleTags = new ArrayList<Tag>();
        ruleTags.addAll(parentTags);
        ruleTags.addAll(rule.getTags());
        for (RuleChild ruleChild : rule.getChildren()) {
            if (ruleChild.getBackground() != null) {
                ruleBackgroundSteps.addAll(ruleChild.getBackground().getSteps());
                continue;
            }
            Scenario scenario = ruleChild.getScenario();
            if (scenario.getExamples().isEmpty()) {
                this.compileScenario(pickles, scenario, ruleTags, ruleBackgroundSteps, language, uri);
                continue;
            }
            this.compileScenarioOutline(pickles, scenario, ruleTags, ruleBackgroundSteps, language, uri);
        }
    }

    private void compileScenario(List<Pickle> pickles, Scenario scenario, List<Tag> parentTags, List<Step> backgroundSteps, String language, String uri) {
        ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
        if (!scenario.getSteps().isEmpty()) {
            steps.addAll(this.pickleSteps(backgroundSteps));
        }
        steps.addAll(this.pickleSteps(scenario.getSteps()));
        ArrayList<Tag> scenarioTags = new ArrayList<Tag>();
        scenarioTags.addAll(parentTags);
        scenarioTags.addAll(scenario.getTags());
        List<String> sourceIds = Collections.singletonList(scenario.getId());
        Pickle pickle = new Pickle(this.idGenerator.newId(), uri, scenario.getName(), language, steps, this.pickleTags(scenarioTags), sourceIds);
        pickles.add(pickle);
    }

    private void compileScenarioOutline(List<Pickle> pickles, Scenario scenario, List<Tag> featureTags, List<Step> backgroundSteps, String language, String uri) {
        for (Examples examples : scenario.getExamples()) {
            if (examples.getTableHeader() == null) continue;
            List variableCells = examples.getTableHeader().getCells();
            for (TableRow valuesRow : examples.getTableBody()) {
                List valueCells = valuesRow.getCells();
                ArrayList<PickleStep> steps = new ArrayList<PickleStep>();
                if (!scenario.getSteps().isEmpty()) {
                    steps.addAll(this.pickleSteps(backgroundSteps));
                }
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.addAll(featureTags);
                tags.addAll(scenario.getTags());
                tags.addAll(examples.getTags());
                for (Step scenarioOutlineStep : scenario.getSteps()) {
                    PickleStep pickleStep = this.pickleStep(scenarioOutlineStep, variableCells, valuesRow);
                    steps.add(pickleStep);
                }
                List<String> sourceIds = Arrays.asList(scenario.getId(), valuesRow.getId());
                Pickle pickle = new Pickle(this.idGenerator.newId(), uri, this.interpolate(scenario.getName(), variableCells, valueCells), language, steps, this.pickleTags(tags), sourceIds);
                pickles.add(pickle);
            }
        }
    }

    private PickleTable pickleDataTable(DataTable dataTable, List<TableCell> variableCells, List<TableCell> valueCells) {
        List rows = dataTable.getRows();
        ArrayList<PickleTableRow> newRows = new ArrayList<PickleTableRow>(rows.size());
        for (TableRow row : rows) {
            List cells = row.getCells();
            ArrayList<PickleTableCell> newCells = new ArrayList<PickleTableCell>();
            for (TableCell cell : cells) {
                newCells.add(new PickleTableCell(this.interpolate(cell.getValue(), variableCells, valueCells)));
            }
            newRows.add(new PickleTableRow(newCells));
        }
        return new PickleTable(newRows);
    }

    private PickleDocString pickleDocString(DocString docString, List<TableCell> variableCells, List<TableCell> valueCells) {
        return new PickleDocString(docString.getMediaType() == null ? null : this.interpolate(docString.getMediaType(), variableCells, valueCells), this.interpolate(docString.getContent(), variableCells, valueCells));
    }

    private PickleStep pickleStep(Step step, List<TableCell> variableCells, TableRow valuesRow) {
        List valueCells = valuesRow == null ? Collections.emptyList() : valuesRow.getCells();
        String stepText = this.interpolate(step.getText(), variableCells, valueCells);
        PickleStep pickleStep = new PickleStep();
        pickleStep.setId(this.idGenerator.newId());
        pickleStep.setAstNodeIds(Collections.singletonList(step.getId()));
        pickleStep.setText(stepText);
        if (valuesRow != null) {
            List astNodeIds = Stream.of(pickleStep.getAstNodeIds(), Collections.singletonList(valuesRow.getId())).flatMap(Collection::stream).collect(Collectors.toList());
            pickleStep.setAstNodeIds(astNodeIds);
        }
        if (step.getDataTable() != null) {
            pickleStep.setArgument(new PickleStepArgument(null, this.pickleDataTable(step.getDataTable(), variableCells, valueCells)));
        }
        if (step.getDocString() != null) {
            pickleStep.setArgument(new PickleStepArgument(this.pickleDocString(step.getDocString(), variableCells, valueCells), null));
        }
        return pickleStep;
    }

    private List<PickleStep> pickleSteps(List<Step> steps) {
        ArrayList<PickleStep> result = new ArrayList<PickleStep>();
        for (Step step : steps) {
            result.add(this.pickleStep(step));
        }
        return Collections.unmodifiableList(result);
    }

    private PickleStep pickleStep(Step step) {
        return this.pickleStep(step, Collections.emptyList(), null);
    }

    private String interpolate(String name, List<TableCell> variableCells, List<TableCell> valueCells) {
        int col = 0;
        for (TableCell variableCell : variableCells) {
            TableCell valueCell = valueCells.get(col++);
            String header = variableCell.getValue();
            String value = valueCell.getValue();
            name = name.replace("<" + header + ">", value);
        }
        return name;
    }

    private List<PickleTag> pickleTags(List<Tag> tags) {
        ArrayList<PickleTag> result = new ArrayList<PickleTag>();
        for (Tag tag : tags) {
            result.add(this.pickleTag(tag));
        }
        return result;
    }

    private PickleTag pickleTag(Tag tag) {
        return new PickleTag(tag.getName(), tag.getId());
    }
}

