/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.gherkin.messages;

import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Step;
import io.cucumber.messages.types.TableRow;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

final class CucumberQuery {
    private final Map<String, Rule> ruleByScenarioId = new HashMap<String, Rule>();
    private final Map<String, Examples> examplesByExampleId = new HashMap<String, Examples>();
    private final Map<String, Feature> featureByScenarioId = new HashMap<String, Feature>();
    private final Map<String, Step> gherkinStepById = new HashMap<String, Step>();
    private final Map<String, Scenario> gherkinScenarioById = new HashMap<String, Scenario>();
    private final Map<String, Location> locationBySourceId = new HashMap<String, Location>();

    CucumberQuery() {
    }

    void update(Feature feature) {
        feature.getChildren().forEach(featureChild -> {
            featureChild.getBackground().ifPresent(this::updateBackground);
            featureChild.getScenario().ifPresent(scenario -> this.updateScenario(feature, null, (Scenario)scenario));
            featureChild.getRule().ifPresent(rule -> rule.getChildren().forEach(ruleChild -> {
                ruleChild.getBackground().ifPresent(this::updateBackground);
                ruleChild.getScenario().ifPresent(scenario -> this.updateScenario(feature, (Rule)rule, (Scenario)scenario));
            }));
        });
    }

    private void updateBackground(Background background) {
        this.updateStep(background.getSteps());
    }

    private void updateScenario(Feature feature, Rule rule, Scenario scenario) {
        this.gherkinScenarioById.put(Objects.requireNonNull(scenario.getId()), scenario);
        this.locationBySourceId.put(Objects.requireNonNull(scenario.getId()), scenario.getLocation());
        this.updateStep(scenario.getSteps());
        for (Examples examples : scenario.getExamples()) {
            for (TableRow tableRow : examples.getTableBody()) {
                this.examplesByExampleId.put(tableRow.getId(), examples);
                this.locationBySourceId.put(tableRow.getId(), tableRow.getLocation());
            }
        }
        if (rule != null) {
            this.ruleByScenarioId.put(scenario.getId(), rule);
        }
        this.featureByScenarioId.put(scenario.getId(), feature);
    }

    private void updateStep(List<Step> stepsList) {
        for (Step step : stepsList) {
            this.locationBySourceId.put(Objects.requireNonNull(step.getId()), step.getLocation());
            this.gherkinStepById.put(Objects.requireNonNull(step.getId()), step);
        }
    }

    Step getStepBy(PickleStep pickleStep) {
        Objects.requireNonNull(pickleStep);
        String gherkinStepId = (String)pickleStep.getAstNodeIds().get(0);
        return Objects.requireNonNull(this.gherkinStepById.get(gherkinStepId));
    }

    Scenario getScenarioBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        return Objects.requireNonNull(this.gherkinScenarioById.get(pickle.getAstNodeIds().get(0)));
    }

    Optional<Rule> findRuleBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        Scenario scenario = this.getScenarioBy(pickle);
        return Optional.ofNullable(this.ruleByScenarioId.get(scenario.getId()));
    }

    Location getLocationBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        List sourceIds = pickle.getAstNodeIds();
        String sourceId = (String)sourceIds.get(sourceIds.size() - 1);
        Location location = this.locationBySourceId.get(sourceId);
        return Objects.requireNonNull(location);
    }

    Optional<Feature> findFeatureBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        Scenario scenario = this.getScenarioBy(pickle);
        return Optional.ofNullable(this.featureByScenarioId.get(scenario.getId()));
    }

    Optional<Examples> findExamplesBy(Pickle pickle) {
        Objects.requireNonNull(pickle);
        List sourceIds = pickle.getAstNodeIds();
        String sourceId = (String)sourceIds.get(sourceIds.size() - 1);
        return Optional.ofNullable(this.examplesByExampleId.get(sourceId));
    }
}

