/*
 * Decompiled with CFR 0.152.
 */
package cucumber.deps.com.thoughtworks.xstream.converters.reflection;

import cucumber.deps.com.thoughtworks.xstream.converters.reflection.FieldKey;
import cucumber.deps.com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import cucumber.deps.com.thoughtworks.xstream.converters.reflection.ImmutableFieldKeySorter;
import cucumber.deps.com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import cucumber.deps.com.thoughtworks.xstream.core.Caching;
import cucumber.deps.com.thoughtworks.xstream.core.JVM;
import cucumber.deps.com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FieldDictionary
implements Caching {
    private transient Map keyedByFieldNameCache;
    private transient Map keyedByFieldKeyCache;
    private final FieldKeySorter sorter;

    public FieldDictionary() {
        this(new ImmutableFieldKeySorter());
    }

    public FieldDictionary(FieldKeySorter sorter) {
        this.sorter = sorter;
        this.init();
    }

    private void init() {
        this.keyedByFieldNameCache = new HashMap();
        this.keyedByFieldKeyCache = new HashMap();
        this.keyedByFieldNameCache.put(Object.class, Collections.EMPTY_MAP);
        this.keyedByFieldKeyCache.put(Object.class, Collections.EMPTY_MAP);
    }

    public Iterator serializableFieldsFor(Class cls) {
        return this.fieldsFor(cls);
    }

    public Iterator fieldsFor(Class cls) {
        return this.buildMap(cls, true).values().iterator();
    }

    public Field field(Class cls, String name, Class definedIn) {
        Field field = this.fieldOrNull(cls, name, definedIn);
        if (field == null) {
            throw new MissingFieldException(cls.getName(), name);
        }
        return field;
    }

    public Field fieldOrNull(Class cls, String name, Class definedIn) {
        Map fields = this.buildMap(cls, definedIn != null);
        Field field = (Field)fields.get(definedIn != null ? new FieldKey(name, definedIn, -1) : name);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildMap(Class type, boolean tupleKeyed) {
        FieldDictionary fieldDictionary = this;
        synchronized (fieldDictionary) {
            if (!this.keyedByFieldNameCache.containsKey(type)) {
                ArrayList<Class> superClasses = new ArrayList<Class>();
                for (Class cls = type; !Object.class.equals((Object)cls) && cls != null; cls = cls.getSuperclass()) {
                    superClasses.add(0, cls);
                }
                HashMap<String, Field> lastKeyedByFieldName = Collections.EMPTY_MAP;
                Map<Object, Object> lastKeyedByFieldKey = Collections.EMPTY_MAP;
                for (Class cls : superClasses) {
                    if (!this.keyedByFieldNameCache.containsKey(cls)) {
                        int i;
                        HashMap<String, Field> keyedByFieldName = new HashMap<String, Field>(lastKeyedByFieldName);
                        OrderRetainingMap keyedByFieldKey = new OrderRetainingMap(lastKeyedByFieldKey);
                        Field[] fields = cls.getDeclaredFields();
                        if (JVM.reverseFieldDefinition()) {
                            i = fields.length >> 1;
                            while (i-- > 0) {
                                int idx = fields.length - i - 1;
                                Field field = fields[i];
                                fields[i] = fields[idx];
                                fields[idx] = field;
                            }
                        }
                        for (i = 0; i < fields.length; ++i) {
                            Field field = fields[i];
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            FieldKey fieldKey = new FieldKey(field.getName(), field.getDeclaringClass(), i);
                            Field existent = (Field)keyedByFieldName.get(field.getName());
                            if (existent == null || (existent.getModifiers() & 8) != 0 || existent != null && (field.getModifiers() & 8) == 0) {
                                keyedByFieldName.put(field.getName(), field);
                            }
                            keyedByFieldKey.put(fieldKey, field);
                        }
                        Map sortedFieldKeys = this.sorter.sort(cls, keyedByFieldKey);
                        this.keyedByFieldNameCache.put(cls, keyedByFieldName);
                        this.keyedByFieldKeyCache.put(cls, sortedFieldKeys);
                        lastKeyedByFieldName = keyedByFieldName;
                        lastKeyedByFieldKey = sortedFieldKeys;
                        continue;
                    }
                    lastKeyedByFieldName = (Map)this.keyedByFieldNameCache.get(cls);
                    lastKeyedByFieldKey = (Map)this.keyedByFieldKeyCache.get(cls);
                }
                return tupleKeyed ? lastKeyedByFieldKey : lastKeyedByFieldName;
            }
        }
        return (Map)(tupleKeyed ? this.keyedByFieldKeyCache.get(type) : this.keyedByFieldNameCache.get(type));
    }

    public synchronized void flushCache() {
        Set<Class<Object>> objectTypeSet = Collections.singleton(Object.class);
        this.keyedByFieldNameCache.keySet().retainAll(objectTypeSet);
        this.keyedByFieldKeyCache.keySet().retainAll(objectTypeSet);
        if (this.sorter instanceof Caching) {
            ((Caching)((Object)this.sorter)).flushCache();
        }
    }

    protected Object readResolve() {
        this.init();
        return this;
    }
}

