
package io.cucumber.messages.types;



/**
 * *
 *  A tag
 * 
 */
public class PickleTag {

    /**
     * 
     * (Required)
     * 
     */
    private String name;
    /**
     * Points to the AST node this was created from
     * (Required)
     * 
     */
    private String astNodeId;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PickleTag() {
    }

    /**
     * 
     * @param astNodeId
     * @param name
     */
    public PickleTag(String name, String astNodeId) {
        super();
        this.name = name;
        this.astNodeId = astNodeId;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Points to the AST node this was created from
     * (Required)
     * 
     */
    public String getAstNodeId() {
        return astNodeId;
    }

    /**
     * Points to the AST node this was created from
     * (Required)
     * 
     */
    public void setAstNodeId(String astNodeId) {
        this.astNodeId = astNodeId;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PickleTag.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("astNodeId");
        sb.append('=');
        sb.append(((this.astNodeId == null)?"<null>":this.astNodeId));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.astNodeId == null)? 0 :this.astNodeId.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PickleTag) == false) {
            return false;
        }
        PickleTag rhs = ((PickleTag) other);
        return (((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name)))&&((this.astNodeId == rhs.astNodeId)||((this.astNodeId!= null)&&this.astNodeId.equals(rhs.astNodeId))));
    }

}
