
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;

public class Scenario {

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    private Location location;
    /**
     * 
     * (Required)
     * 
     */
    private List<Tag> tags = new ArrayList<Tag>();
    /**
     * 
     * (Required)
     * 
     */
    private String keyword;
    /**
     * 
     * (Required)
     * 
     */
    private String name;
    /**
     * 
     * (Required)
     * 
     */
    private String description;
    /**
     * 
     * (Required)
     * 
     */
    private List<Step> steps = new ArrayList<Step>();
    /**
     * 
     * (Required)
     * 
     */
    private List<Examples> examples = new ArrayList<Examples>();
    /**
     * 
     * (Required)
     * 
     */
    private String id;

    /**
     * No args constructor for use in serialization
     * 
     */
    public Scenario() {
    }

    /**
     * 
     * @param examples
     * @param name
     * @param description
     * @param location
     * @param id
     * @param keyword
     * @param steps
     * @param tags
     */
    public Scenario(Location location, List<Tag> tags, String keyword, String name, String description, List<Step> steps, List<Examples> examples, String id) {
        super();
        this.location = location;
        this.tags = tags;
        this.keyword = keyword;
        this.name = name;
        this.description = description;
        this.steps = steps;
        this.examples = examples;
        this.id = id;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public Location getLocation() {
        return location;
    }

    /**
     * *
     *  Points to a line and a column in a text file
     * (Required)
     * 
     */
    public void setLocation(Location location) {
        this.location = location;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<Tag> getTags() {
        return tags;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getKeyword() {
        return keyword;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getName() {
        return name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getDescription() {
        return description;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<Step> getSteps() {
        return steps;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    /**
     * 
     * (Required)
     * 
     */
    public List<Examples> getExamples() {
        return examples;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setExamples(List<Examples> examples) {
        this.examples = examples;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Scenario.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("location");
        sb.append('=');
        sb.append(((this.location == null)?"<null>":this.location));
        sb.append(',');
        sb.append("tags");
        sb.append('=');
        sb.append(((this.tags == null)?"<null>":this.tags));
        sb.append(',');
        sb.append("keyword");
        sb.append('=');
        sb.append(((this.keyword == null)?"<null>":this.keyword));
        sb.append(',');
        sb.append("name");
        sb.append('=');
        sb.append(((this.name == null)?"<null>":this.name));
        sb.append(',');
        sb.append("description");
        sb.append('=');
        sb.append(((this.description == null)?"<null>":this.description));
        sb.append(',');
        sb.append("steps");
        sb.append('=');
        sb.append(((this.steps == null)?"<null>":this.steps));
        sb.append(',');
        sb.append("examples");
        sb.append('=');
        sb.append(((this.examples == null)?"<null>":this.examples));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.examples == null)? 0 :this.examples.hashCode()));
        result = ((result* 31)+((this.name == null)? 0 :this.name.hashCode()));
        result = ((result* 31)+((this.description == null)? 0 :this.description.hashCode()));
        result = ((result* 31)+((this.location == null)? 0 :this.location.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.keyword == null)? 0 :this.keyword.hashCode()));
        result = ((result* 31)+((this.steps == null)? 0 :this.steps.hashCode()));
        result = ((result* 31)+((this.tags == null)? 0 :this.tags.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof Scenario) == false) {
            return false;
        }
        Scenario rhs = ((Scenario) other);
        return (((((((((this.examples == rhs.examples)||((this.examples!= null)&&this.examples.equals(rhs.examples)))&&((this.name == rhs.name)||((this.name!= null)&&this.name.equals(rhs.name))))&&((this.description == rhs.description)||((this.description!= null)&&this.description.equals(rhs.description))))&&((this.location == rhs.location)||((this.location!= null)&&this.location.equals(rhs.location))))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.keyword == rhs.keyword)||((this.keyword!= null)&&this.keyword.equals(rhs.keyword))))&&((this.steps == rhs.steps)||((this.steps!= null)&&this.steps.equals(rhs.steps))))&&((this.tags == rhs.tags)||((this.tags!= null)&&this.tags.equals(rhs.tags))));
    }

}
