
package io.cucumber.messages.types;

import java.util.ArrayList;
import java.util.List;


/**
 * *
 *  An executable step
 * 
 */
public class PickleStep {

    /**
     * An optional argument
     * 
     */
    private PickleStepArgument argument;
    /**
     * References the IDs of the source of the step. For Gherkin, this can be
     *  the ID of a Step, and possibly also the ID of a TableRow
     * (Required)
     * 
     */
    private List<String> astNodeIds = new ArrayList<String>();
    /**
     * A unique ID for the PickleStep
     * (Required)
     * 
     */
    private String id;
    /**
     * 
     * (Required)
     * 
     */
    private String text;

    /**
     * No args constructor for use in serialization
     * 
     */
    public PickleStep() {
    }

    /**
     * 
     * @param argument
     * @param id
     * @param text
     * @param astNodeIds
     */
    public PickleStep(PickleStepArgument argument, List<String> astNodeIds, String id, String text) {
        super();
        this.argument = argument;
        this.astNodeIds = astNodeIds;
        this.id = id;
        this.text = text;
    }

    /**
     * An optional argument
     * 
     */
    public PickleStepArgument getArgument() {
        return argument;
    }

    /**
     * An optional argument
     * 
     */
    public void setArgument(PickleStepArgument argument) {
        this.argument = argument;
    }

    /**
     * References the IDs of the source of the step. For Gherkin, this can be
     *  the ID of a Step, and possibly also the ID of a TableRow
     * (Required)
     * 
     */
    public List<String> getAstNodeIds() {
        return astNodeIds;
    }

    /**
     * References the IDs of the source of the step. For Gherkin, this can be
     *  the ID of a Step, and possibly also the ID of a TableRow
     * (Required)
     * 
     */
    public void setAstNodeIds(List<String> astNodeIds) {
        this.astNodeIds = astNodeIds;
    }

    /**
     * A unique ID for the PickleStep
     * (Required)
     * 
     */
    public String getId() {
        return id;
    }

    /**
     * A unique ID for the PickleStep
     * (Required)
     * 
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 
     * (Required)
     * 
     */
    public String getText() {
        return text;
    }

    /**
     * 
     * (Required)
     * 
     */
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(PickleStep.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("argument");
        sb.append('=');
        sb.append(((this.argument == null)?"<null>":this.argument));
        sb.append(',');
        sb.append("astNodeIds");
        sb.append('=');
        sb.append(((this.astNodeIds == null)?"<null>":this.astNodeIds));
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(((this.id == null)?"<null>":this.id));
        sb.append(',');
        sb.append("text");
        sb.append('=');
        sb.append(((this.text == null)?"<null>":this.text));
        sb.append(',');
        if (sb.charAt((sb.length()- 1)) == ',') {
            sb.setCharAt((sb.length()- 1), ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = ((result* 31)+((this.argument == null)? 0 :this.argument.hashCode()));
        result = ((result* 31)+((this.id == null)? 0 :this.id.hashCode()));
        result = ((result* 31)+((this.text == null)? 0 :this.text.hashCode()));
        result = ((result* 31)+((this.astNodeIds == null)? 0 :this.astNodeIds.hashCode()));
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if ((other instanceof PickleStep) == false) {
            return false;
        }
        PickleStep rhs = ((PickleStep) other);
        return (((((this.argument == rhs.argument)||((this.argument!= null)&&this.argument.equals(rhs.argument)))&&((this.id == rhs.id)||((this.id!= null)&&this.id.equals(rhs.id))))&&((this.text == rhs.text)||((this.text!= null)&&this.text.equals(rhs.text))))&&((this.astNodeIds == rhs.astNodeIds)||((this.astNodeIds!= null)&&this.astNodeIds.equals(rhs.astNodeIds))));
    }

}
