/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Timestamp;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.Objects;

public final class Convertor {
    private Convertor() {
    }

    public static Exception toMessage(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable may not be null");
        return new Exception(throwable.getClass().getName(), throwable.getMessage(), Convertor.extractStackTrace(throwable));
    }

    private static String extractStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            throwable.printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public static Timestamp toMessage(Instant instant) {
        Objects.requireNonNull(instant, "instant may not be null");
        return new Timestamp(instant.getEpochSecond(), Long.valueOf(instant.getNano()));
    }

    public static Duration toMessage(java.time.Duration duration) {
        Objects.requireNonNull(duration, "duration may not be null");
        return new Duration(duration.getSeconds(), Long.valueOf(duration.getNano()));
    }

    public static Instant toInstant(Timestamp timestamp) {
        Objects.requireNonNull(timestamp, "timestamp may not be null");
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    public static java.time.Duration toDuration(Duration duration) {
        Objects.requireNonNull(duration, "duration may not be null");
        return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
    }
}

