/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Timestamp;
import java.util.Objects;
import java.util.Optional;

public final class TestRunFinished {
    private final String message;
    private final Boolean success;
    private final Timestamp timestamp;
    private final Exception exception;
    private final String testRunStartedId;

    public TestRunFinished(String message, Boolean success, Timestamp timestamp, Exception exception, String testRunStartedId) {
        this.message = message;
        this.success = Objects.requireNonNull(success, "TestRunFinished.success cannot be null");
        this.timestamp = Objects.requireNonNull(timestamp, "TestRunFinished.timestamp cannot be null");
        this.exception = exception;
        this.testRunStartedId = testRunStartedId;
    }

    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Optional<Exception> getException() {
        return Optional.ofNullable(this.exception);
    }

    public Optional<String> getTestRunStartedId() {
        return Optional.ofNullable(this.testRunStartedId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestRunFinished that = (TestRunFinished)o;
        return Objects.equals(this.message, that.message) && this.success.equals(that.success) && this.timestamp.equals(that.timestamp) && Objects.equals(this.exception, that.exception) && Objects.equals(this.testRunStartedId, that.testRunStartedId);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.success, this.timestamp, this.exception, this.testRunStartedId);
    }

    public String toString() {
        return "TestRunFinished{message=" + this.message + ", success=" + this.success + ", timestamp=" + this.timestamp + ", exception=" + this.exception + ", testRunStartedId=" + this.testRunStartedId + '}';
    }
}

