/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.Group;
import java.util.Objects;
import java.util.Optional;

public final class StepMatchArgument {
    private final Group group;
    private final String parameterTypeName;

    public StepMatchArgument(Group group, String parameterTypeName) {
        this.group = Objects.requireNonNull(group, "StepMatchArgument.group cannot be null");
        this.parameterTypeName = parameterTypeName;
    }

    public Group getGroup() {
        return this.group;
    }

    public Optional<String> getParameterTypeName() {
        return Optional.ofNullable(this.parameterTypeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepMatchArgument that = (StepMatchArgument)o;
        return this.group.equals(that.group) && Objects.equals(this.parameterTypeName, that.parameterTypeName);
    }

    public int hashCode() {
        return Objects.hash(this.group, this.parameterTypeName);
    }

    public String toString() {
        return "StepMatchArgument{group=" + this.group + ", parameterTypeName=" + this.parameterTypeName + '}';
    }
}

