/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.teamcityformatter;

import io.cucumber.messages.Convertor;
import io.cucumber.messages.types.Attachment;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Exception;
import io.cucumber.messages.types.Hook;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Pickle;
import io.cucumber.messages.types.PickleStep;
import io.cucumber.messages.types.TestCaseFinished;
import io.cucumber.messages.types.TestCaseStarted;
import io.cucumber.messages.types.TestRunFinished;
import io.cucumber.messages.types.TestRunStarted;
import io.cucumber.messages.types.TestStep;
import io.cucumber.messages.types.TestStepFinished;
import io.cucumber.messages.types.TestStepResult;
import io.cucumber.messages.types.TestStepResultStatus;
import io.cucumber.messages.types.TestStepStarted;
import io.cucumber.messages.types.Timestamp;
import io.cucumber.query.LineageReducer;
import io.cucumber.query.Query;
import io.cucumber.teamcityformatter.ComparisonFailure;
import io.cucumber.teamcityformatter.LineageNode;
import io.cucumber.teamcityformatter.OrderableEvent;
import io.cucumber.teamcityformatter.PathCollector;
import io.cucumber.teamcityformatter.SourceReferenceFormatter;
import io.cucumber.teamcityformatter.SuggestionFormatter;
import io.cucumber.teamcityformatter.TeamCityCommandWriter;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;

final class TeamCityWriter
implements AutoCloseable {
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private static final String TEAMCITY_PREFIX = "##teamcity";
    private static final String TEMPLATE_ENTER_THE_MATRIX = "##teamcity[enteredTheMatrix timestamp = '%s']";
    private static final String TEMPLATE_TEST_RUN_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_RUN_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = 'Cucumber']";
    private static final String TEMPLATE_TEST_SUITE_STARTED = "##teamcity[testSuiteStarted timestamp = '%s' locationHint = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_SUITE_FINISHED = "##teamcity[testSuiteFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_STARTED = "##teamcity[testStarted timestamp = '%s' locationHint = '%s' captureStandardOutput = 'true' name = '%s']";
    private static final String TEMPLATE_TEST_FINISHED = "##teamcity[testFinished timestamp = '%s' duration = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_FAILED = "##teamcity[testFailed timestamp = '%s' duration = '%s' message = '%s' details = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_COMPARISON_FAILED = "##teamcity[testFailed timestamp = '%s' duration = '%s' message = '%s' details = '%s' expected = '%s' actual = '%s' name = '%s']";
    private static final String TEMPLATE_TEST_IGNORED = "##teamcity[testIgnored timestamp = '%s' duration = '%s' message = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_STARTED = "##teamcity[testStarted timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_FAILED = "##teamcity[testFailed timestamp = '%s' message = '%s' details = '%s' name = '%s']";
    private static final String TEMPLATE_BEFORE_ALL_AFTER_ALL_FINISHED = "##teamcity[testFinished timestamp = '%s' name = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_STARTED = "##teamcity[customProgressStatus testsCategory = 'Scenarios' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_COUNTING_FINISHED = "##teamcity[customProgressStatus testsCategory = '' count = '0' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_STARTED = "##teamcity[customProgressStatus type = 'testStarted' timestamp = '%s']";
    private static final String TEMPLATE_PROGRESS_TEST_FINISHED = "##teamcity[customProgressStatus type = 'testFinished' timestamp = '%s']";
    private static final String TEMPLATE_ATTACH_WRITE_EVENT = "##teamcity[message text='%s' status='NORMAL']";
    private final LineageReducer<List<LineageNode>> pathCollector = LineageReducer.descending(PathCollector::new);
    private final Map<String, List<String>> attachmentMessagesByStepId = new HashMap<String, List<String>>();
    private List<LineageNode> currentLineage = new ArrayList<LineageNode>();
    private final TeamCityCommandWriter out;
    private final Query query;

    TeamCityWriter(TeamCityCommandWriter out, Query query) {
        this.out = out;
        this.query = query;
    }

    void printTestCasesRealTime(Envelope event) {
        event.getTestRunStarted().ifPresent(this::printTestRunStarted);
        event.getTestCaseStarted().ifPresent(this::printTestCaseStarted);
        event.getTestStepStarted().ifPresent(this::printTestStepStarted);
        event.getTestStepFinished().ifPresent(this::printTestStepFinished);
        event.getTestCaseFinished().ifPresent(this::printTestCaseFinished);
        event.getTestRunFinished().ifPresent(this::printTestRunFinished);
        event.getAttachment().ifPresent(this::handleAttachment);
    }

    void printTestCasesAfterTestRun(Envelope event) {
        event.getTestRunStarted().ifPresent(this::printTestRunStarted);
        event.getTestRunFinished().ifPresent(this::printCompleteTestRun);
        event.getAttachment().ifPresent(this::storeStepAttachments);
    }

    private void printCompleteTestRun(TestRunFinished event) {
        this.findAllTestCaseStartedInCanonicalOrder().forEach(this::printCompleteTestCase);
        this.printTestRunFinished(event);
    }

    private Stream<TestCaseStarted> findAllTestCaseStartedInCanonicalOrder() {
        return this.query.findAllTestCaseStarted().stream().map(testCaseStarted -> {
            Optional pickle = this.query.findPickleBy(testCaseStarted);
            String uri = pickle.map(Pickle::getUri).orElse(null);
            Long line = pickle.flatMap(arg_0 -> ((Query)this.query).findLocationOf(arg_0)).map(Location::getLine).orElse(null);
            return new OrderableEvent<TestCaseStarted>((TestCaseStarted)testCaseStarted, uri, line);
        }).sorted().map(OrderableEvent::getEvent);
    }

    @Override
    public void close() {
        this.out.close();
    }

    private void printCompleteTestCase(TestCaseStarted testCaseStarted) {
        this.printTestCaseStarted(testCaseStarted);
        this.query.findTestStepsStartedBy(testCaseStarted).forEach(testStepStarted -> {
            this.printTestStepStarted((TestStepStarted)testStepStarted);
            this.findAttachmentBy((TestStepStarted)testStepStarted).forEach(this::handleAttachment);
            this.findTestStepFinishedBy(testCaseStarted, (TestStepStarted)testStepStarted).ifPresent(this::printTestStepFinished);
        });
        this.query.findTestCaseFinishedBy(testCaseStarted).ifPresent(this::printTestCaseFinished);
    }

    private List<String> findAttachmentBy(TestStepStarted testStepStarted) {
        return this.attachmentMessagesByStepId.getOrDefault(testStepStarted.getTestStepId(), Collections.emptyList());
    }

    private Optional<TestStepFinished> findTestStepFinishedBy(TestCaseStarted testCaseStarted, TestStepStarted testStepStarted) {
        return this.query.findTestStepsFinishedBy(testCaseStarted).stream().filter(testStepFinished -> testStepFinished.getTestStepId().equals(testStepStarted.getTestStepId())).findFirst();
    }

    private void storeStepAttachments(Attachment event) {
        Optional testStepId = event.getTestStepId();
        if (testStepId.isPresent()) {
            this.attachmentMessagesByStepId.compute((String)testStepId.get(), this.updateList(TeamCityWriter.extractAttachmentMessage(event)));
        } else {
            this.handleAttachment(event);
        }
    }

    private <K, E> BiFunction<K, List<E>, List<E>> updateList(E element) {
        return (key, existing) -> {
            if (existing != null) {
                existing.add(element);
                return existing;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(element);
            return list;
        };
    }

    private void printTestRunStarted(TestRunStarted event) {
        String timestamp = TeamCityWriter.formatTimeStamp(event.getTimestamp());
        this.out.print(TEMPLATE_ENTER_THE_MATRIX, timestamp);
        this.out.print(TEMPLATE_TEST_RUN_STARTED, timestamp);
        this.out.print(TEMPLATE_PROGRESS_COUNTING_STARTED, timestamp);
    }

    private void printTestCaseStarted(TestCaseStarted event) {
        this.query.findPickleBy(event).flatMap(this::createLineageOf).ifPresent(lineage -> {
            String timestamp = TeamCityWriter.formatTimeStamp(event.getTimestamp());
            this.poppedNodes((List<LineageNode>)lineage).forEach(node -> this.finishNode(timestamp, (LineageNode)node));
            this.pushedNodes((List<LineageNode>)lineage).forEach(node -> this.startNode(timestamp, (LineageNode)node));
            this.currentLineage = lineage;
            this.out.print(TEMPLATE_PROGRESS_TEST_STARTED, timestamp);
        });
    }

    private Optional<List<LineageNode>> createLineageOf(Pickle pickle) {
        return this.query.findLineageBy(pickle).map(lineage -> (List)this.pathCollector.reduce(lineage, pickle));
    }

    private void startNode(String timestamp, LineageNode node) {
        String name = node.getName();
        String location = node.getUri() + ":" + node.getLocation().getLine();
        this.out.print(TEMPLATE_TEST_SUITE_STARTED, timestamp, location, name);
    }

    private void finishNode(String timestamp, LineageNode node) {
        String name = node.getName();
        this.out.print(TEMPLATE_TEST_SUITE_FINISHED, timestamp, name);
    }

    private List<LineageNode> poppedNodes(List<LineageNode> newLineage) {
        ArrayList<LineageNode> nodes = new ArrayList<LineageNode>(this.reversedPoppedNodes(this.currentLineage, newLineage));
        Collections.reverse(nodes);
        return nodes;
    }

    private List<LineageNode> reversedPoppedNodes(List<LineageNode> currentLineage, List<LineageNode> newLineage) {
        for (int i = 0; i < currentLineage.size() && i < newLineage.size(); ++i) {
            if (currentLineage.get(i).equals(newLineage.get(i))) continue;
            return currentLineage.subList(i, currentLineage.size());
        }
        if (newLineage.size() < currentLineage.size()) {
            return currentLineage.subList(newLineage.size(), currentLineage.size());
        }
        return Collections.emptyList();
    }

    private List<LineageNode> pushedNodes(List<LineageNode> newLineage) {
        for (int i = 0; i < this.currentLineage.size() && i < newLineage.size(); ++i) {
            if (this.currentLineage.get(i).equals(newLineage.get(i))) continue;
            return newLineage.subList(i, newLineage.size());
        }
        if (newLineage.size() < this.currentLineage.size()) {
            return Collections.emptyList();
        }
        return newLineage.subList(this.currentLineage.size(), newLineage.size());
    }

    private void printTestStepStarted(TestStepStarted event) {
        String timestamp = TeamCityWriter.formatTimeStamp(event.getTimestamp());
        this.query.findTestStepBy(event).ifPresent(testStep -> {
            String name = this.formatTestStepName((TestStep)testStep);
            String location = this.findPickleTestStepLocation(event, (TestStep)testStep).orElseGet(() -> this.findHookStepLocation((TestStep)testStep).orElse(""));
            this.out.print(TEMPLATE_TEST_STARTED, timestamp, location, name);
        });
    }

    private Optional<String> findPickleTestStepLocation(TestStepStarted testStepStarted, TestStep testStep) {
        return this.query.findPickleStepBy(testStep).flatMap(arg_0 -> ((Query)this.query).findStepBy(arg_0)).flatMap(step -> this.query.findPickleBy(testStepStarted).map(pickle -> pickle.getUri() + ":" + step.getLocation().getLine()));
    }

    private Optional<String> findHookStepLocation(TestStep testStep) {
        return this.query.findHookBy(testStep).map(Hook::getSourceReference).flatMap(SourceReferenceFormatter::formatLocation);
    }

    private void printTestStepFinished(TestStepFinished event) {
        String timeStamp = TeamCityWriter.formatTimeStamp(event.getTimestamp());
        TestStepResult testStepResult = event.getTestStepResult();
        long duration = Convertor.toDuration((Duration)testStepResult.getDuration()).toMillis();
        this.query.findTestStepBy(event).ifPresent(testStep -> {
            String name = this.formatTestStepName((TestStep)testStep);
            Optional error = testStepResult.getException();
            TestStepResultStatus status = testStepResult.getStatus();
            switch (status) {
                case SKIPPED: {
                    String message = error.flatMap(Exception::getMessage).orElse("Step skipped");
                    this.out.print(TEMPLATE_TEST_IGNORED, timeStamp, duration, message, name);
                    break;
                }
                case PENDING: {
                    String details = error.flatMap(Exception::getMessage).orElse("");
                    this.out.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step pending", details, name);
                    break;
                }
                case UNDEFINED: {
                    String snippets = this.findSnippets(event).orElse("");
                    this.out.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step undefined", snippets, name);
                    break;
                }
                case AMBIGUOUS: 
                case FAILED: {
                    String details = error.flatMap(Exception::getStackTrace).orElse("");
                    String message = error.flatMap(Exception::getMessage).orElse(null);
                    if (message == null) {
                        this.out.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step failed", details, name);
                        break;
                    }
                    ComparisonFailure comparisonFailure = ComparisonFailure.parse(message.trim());
                    if (comparisonFailure == null) {
                        this.out.print(TEMPLATE_TEST_FAILED, timeStamp, duration, "Step failed", details, name);
                        break;
                    }
                    this.out.print(TEMPLATE_TEST_COMPARISON_FAILED, timeStamp, duration, "Step failed", details, comparisonFailure.getExpected(), comparisonFailure.getActual(), name);
                    break;
                }
            }
            this.out.print(TEMPLATE_TEST_FINISHED, timeStamp, duration, name);
        });
    }

    private String formatTestStepName(TestStep testStep) {
        return this.query.findPickleStepBy(testStep).map(PickleStep::getText).orElseGet(() -> this.query.findHookBy(testStep).map(TeamCityWriter::formatHookStepName).orElse("Unknown step"));
    }

    private static String formatHookStepName(Hook hook) {
        String hookType = TeamCityWriter.getHookType(hook);
        String name = hook.getName().map(hookName -> "(" + hookName + ")").orElseGet(() -> SourceReferenceFormatter.formatMethodName(hook.getSourceReference()).map(methodName -> "(" + methodName + ")").orElse(""));
        return hookType + name;
    }

    private static String getHookType(Hook hook) {
        return hook.getType().map(hookType -> {
            switch (hookType) {
                case BEFORE_TEST_RUN: {
                    return "BeforeAll";
                }
                case AFTER_TEST_RUN: {
                    return "AfterAll";
                }
                case BEFORE_TEST_CASE: {
                    return "Before";
                }
                case AFTER_TEST_CASE: {
                    return "After";
                }
                case BEFORE_TEST_STEP: {
                    return "BeforeStep";
                }
                case AFTER_TEST_STEP: {
                    return "AfterStep";
                }
            }
            return "Unknown";
        }).orElse("Unknown");
    }

    private Optional<String> findSnippets(TestStepFinished event) {
        return this.query.findPickleBy(event).map(arg_0 -> ((Query)this.query).findSuggestionsBy(arg_0)).map(SuggestionFormatter::format);
    }

    private void printTestCaseFinished(TestCaseFinished event) {
        String timestamp = TeamCityWriter.formatTimeStamp(event.getTimestamp());
        this.out.print(TEMPLATE_PROGRESS_TEST_FINISHED, timestamp);
        this.finishNode(timestamp, this.currentLineage.remove(this.currentLineage.size() - 1));
    }

    private void printTestRunFinished(TestRunFinished event) {
        String timestamp = TeamCityWriter.formatTimeStamp(event.getTimestamp());
        this.out.print(TEMPLATE_PROGRESS_COUNTING_FINISHED, timestamp);
        ArrayList<LineageNode> emptyPath = new ArrayList<LineageNode>();
        this.poppedNodes(emptyPath).forEach(node -> this.finishNode(timestamp, (LineageNode)node));
        this.currentLineage = emptyPath;
        this.printBeforeAfterAllResult(event, timestamp);
        this.out.print(TEMPLATE_TEST_RUN_FINISHED, timestamp);
    }

    private void printBeforeAfterAllResult(TestRunFinished event, String timestamp) {
        Optional error = event.getException();
        if (!error.isPresent()) {
            return;
        }
        String name = "Before All/After All";
        this.out.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_STARTED, timestamp, name);
        String details = error.flatMap(Exception::getStackTrace).orElse("");
        this.out.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_FAILED, timestamp, "Before All/After All failed", details, name);
        this.out.print(TEMPLATE_BEFORE_ALL_AFTER_ALL_FINISHED, timestamp, name);
    }

    private void handleAttachment(Attachment event) {
        String message = TeamCityWriter.extractAttachmentMessage(event);
        if (message != null) {
            this.handleAttachment(message);
        }
    }

    private void handleAttachment(String message) {
        this.out.print(TEMPLATE_ATTACH_WRITE_EVENT, message);
    }

    private static String extractAttachmentMessage(Attachment event) {
        switch (event.getContentEncoding()) {
            case IDENTITY: {
                return "Write event:\n" + event.getBody() + "\n";
            }
            case BASE64: {
                String name = event.getFileName().map(s -> s + " ").orElse("");
                return "Embed event: " + name + "[" + event.getMediaType() + " " + event.getBody().length() / 4 * 3 + " bytes]\n";
            }
        }
        return null;
    }

    private static String formatTimeStamp(Timestamp timestamp) {
        ZonedDateTime date = Convertor.toInstant((Timestamp)timestamp).atZone(ZoneOffset.UTC);
        return DATE_FORMAT.format(date);
    }
}

