/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.testngxmlformatter;

import java.util.Objects;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class EscapingXmlStreamWriter
implements AutoCloseable {
    private final XMLStreamWriter writer;
    private static final Pattern CDATA_TERMINATOR_SPLIT = Pattern.compile("(?<=]])(?=>)");

    public EscapingXmlStreamWriter(XMLStreamWriter writer) {
        this.writer = Objects.requireNonNull(writer);
    }

    @Override
    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
    }

    public void newLine() throws XMLStreamException {
        this.writer.writeCharacters("\n");
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writer.writeStartElement(localName);
    }

    public void writeEndElement() throws XMLStreamException {
        this.writer.writeEndElement();
    }

    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writer.writeEmptyElement(localName);
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, EscapingXmlStreamWriter.escapeIllegalChars(value));
    }

    public void writeCData(String data) throws XMLStreamException {
        for (String part : CDATA_TERMINATOR_SPLIT.split(data)) {
            this.writer.writeCData(EscapingXmlStreamWriter.escapeIllegalChars(part));
        }
    }

    private static String escapeIllegalChars(String value) {
        boolean allAllowed = true;
        int i = 0;
        while (i < value.length()) {
            int codePoint = value.codePointAt(i);
            if (!EscapingXmlStreamWriter.isLegal(codePoint)) {
                allAllowed = false;
                break;
            }
            i = Character.offsetByCodePoints(value, i, 1);
        }
        if (allAllowed) {
            return value;
        }
        StringBuilder escaped = new StringBuilder();
        int i2 = 0;
        while (i2 < value.length()) {
            int codePoint = value.codePointAt(i2);
            if (EscapingXmlStreamWriter.isLegal(codePoint)) {
                escaped.appendCodePoint(codePoint);
            } else {
                escaped.append("&#").append(codePoint).append(';');
            }
            i2 = Character.offsetByCodePoints(value, i2, 1);
        }
        return escaped.toString();
    }

    private static boolean isLegal(int codePoint) {
        return codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 0x10FFFF;
    }
}

