/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.usageformatter;

import io.cucumber.messages.types.Envelope;
import io.cucumber.query.Query;
import io.cucumber.query.Repository;
import io.cucumber.usageformatter.UsageReport;
import io.cucumber.usageformatter.UsageReportBuilder;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class MessagesToUsageWriter
implements AutoCloseable {
    private final OutputStreamWriter out;
    private final Repository repository = Repository.builder().feature(Repository.RepositoryFeature.INCLUDE_GHERKIN_DOCUMENTS, true).feature(Repository.RepositoryFeature.INCLUDE_STEP_DEFINITIONS, true).build();
    private final Query query = new Query(this.repository);
    private final Serializer serializer;
    private boolean streamClosed = false;

    MessagesToUsageWriter(OutputStream out, Serializer serializer) {
        this.out = new OutputStreamWriter(Objects.requireNonNull(out), StandardCharsets.UTF_8);
        this.serializer = Objects.requireNonNull(serializer);
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        this.repository.update(envelope);
    }

    public static Builder builder(Serializer serializer) {
        return new Builder(serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        try {
            UsageReport report = new UsageReportBuilder(this.query).build();
            this.serializer.writeValue(this.out, report);
        }
        finally {
            try {
                this.out.close();
            }
            finally {
                this.streamClosed = true;
            }
        }
    }

    @FunctionalInterface
    public static interface Serializer {
        public void writeValue(Writer var1, UsageReport var2) throws IOException;
    }

    public static final class Builder {
        private final Serializer serializer;

        private Builder(Serializer serializer) {
            this.serializer = Objects.requireNonNull(serializer);
        }

        public MessagesToUsageWriter build(OutputStream out) {
            Objects.requireNonNull(out);
            return new MessagesToUsageWriter(out, this.serializer);
        }
    }
}

