/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.usageformatter;

import io.cucumber.messages.DurationComparator;
import io.cucumber.messages.types.Duration;
import io.cucumber.messages.types.Location;
import io.cucumber.usageformatter.Durations;
import io.cucumber.usageformatter.MessagesToUsageWriter;
import io.cucumber.usageformatter.SourceReferenceFormatter;
import io.cucumber.usageformatter.Table;
import io.cucumber.usageformatter.TableFormatter;
import io.cucumber.usageformatter.UsageReport;
import java.io.IOException;
import java.io.Writer;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;

public final class UsageReportSerializer
implements MessagesToUsageWriter.Serializer {
    private static final int INCLUDE_ALL_STEPS = -1;
    private static final DurationComparator durationComparator = new DurationComparator();
    public final String[] headers = new String[]{"Expression/Text", "Duration", "Mean", "\u00b1", "Error", "Location"};
    public final boolean[] leftAlignColumn = new boolean[]{true, false, false, true, false, true};
    public final int maxStepsPerStepDefinition;
    private final Set<PlainTextFeature> features;
    private final Function<String, String> uriFormatter;
    private final SourceReferenceFormatter sourceReferenceFormatter;

    private UsageReportSerializer(int maxStepsPerStepDefinition, Set<PlainTextFeature> features, Function<String, String> uriFormatter) {
        this.maxStepsPerStepDefinition = maxStepsPerStepDefinition;
        this.features = features;
        this.uriFormatter = Objects.requireNonNull(uriFormatter);
        this.sourceReferenceFormatter = new SourceReferenceFormatter(uriFormatter);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void writeValue(Writer writer, UsageReport value) throws IOException {
        writer.append(this.format(value));
    }

    private String format(UsageReport usageReport) {
        List<UsageReport.StepDefinitionUsage> stepDefinitions = usageReport.getStepDefinitions();
        if (stepDefinitions.isEmpty()) {
            return "";
        }
        Table table = this.createTable(stepDefinitions);
        return TableFormatter.format(table, this.leftAlignColumn);
    }

    private Table createTable(List<UsageReport.StepDefinitionUsage> stepDefinitions) {
        return stepDefinitions.stream().sorted(UsageReportSerializer.byMeanDurationDescending()).map(this::createRows).reduce(new Table(this.headers), Table::addTo);
    }

    private Table createRows(UsageReport.StepDefinitionUsage stepDefinitionUsage) {
        Table table = new Table();
        UsageReport.Statistics duration = stepDefinitionUsage.getDuration();
        table.add(stepDefinitionUsage.getExpression().getSource(), duration == null ? "" : this.formatDuration(duration.getSum()), duration == null ? "" : this.formatDuration(duration.getMean()), duration == null ? "" : "\u00b1", duration == null ? "" : this.formatDuration(duration.getMoe95()), this.sourceReferenceFormatter.format(stepDefinitionUsage.getSourceReference()).orElse(""));
        if (!this.features.contains((Object)PlainTextFeature.INCLUDE_STEPS)) {
            return table;
        }
        List<UsageReport.StepUsage> steps = stepDefinitionUsage.getMatches();
        if (steps.isEmpty()) {
            table.add("  UNUSED", "", "", "", "", "");
            return table;
        }
        boolean includeAllSteps = this.maxStepsPerStepDefinition == -1;
        int includeToIndex = includeAllSteps ? steps.size() : Math.min(this.maxStepsPerStepDefinition, steps.size());
        steps.stream().sorted(Comparator.comparing(UsageReport.StepUsage::getDuration, durationComparator).reversed()).limit(includeToIndex).forEach(stepUsage -> table.add("  " + stepUsage.getText(), this.formatDuration(stepUsage.getDuration()), "", "", "", this.uriFormatter.apply(stepUsage.getUri()) + stepUsage.getLocation().map(Location::getLine).map(line -> ":" + line).orElse("")));
        if (steps.size() > includeToIndex) {
            table.add("  " + (steps.size() - includeToIndex) + " more", "", "", "", "", "");
        }
        return table;
    }

    private static Comparator<UsageReport.StepDefinitionUsage> byMeanDurationDescending() {
        Comparator<UsageReport.Statistics> compareMean = Comparator.comparing(UsageReport.Statistics::getMean, new DurationComparator());
        return Comparator.comparing(UsageReport.StepDefinitionUsage::getDuration, Comparator.nullsFirst(compareMean)).reversed();
    }

    private String formatDuration(Duration duration) {
        return Durations.toBigDecimalSeconds(duration).setScale(3, RoundingMode.HALF_EVEN).toPlainString() + "s";
    }

    public static final class Builder {
        private final Set<PlainTextFeature> features = EnumSet.noneOf(PlainTextFeature.class);
        private int maxStepsPerStepDefinition = -1;
        private Function<String, String> uriFormatter = Function.identity();

        public Builder feature(PlainTextFeature feature, boolean enabled) {
            if (enabled) {
                this.features.add(feature);
            } else {
                this.features.remove((Object)feature);
            }
            return this;
        }

        public Builder maxStepsPerStepDefinition(int n) {
            this.maxStepsPerStepDefinition = n < 0 ? -1 : n;
            return this;
        }

        public Builder removeUriPrefix(String prefix) {
            this.uriFormatter = Builder.removePrefix(Objects.requireNonNull(prefix));
            return this;
        }

        private static Function<String, String> removePrefix(String prefix) {
            return s -> {
                if (s.startsWith(prefix)) {
                    return s.substring(prefix.length());
                }
                return s;
            };
        }

        public UsageReportSerializer build() {
            return new UsageReportSerializer(this.maxStepsPerStepDefinition, this.features, this.uriFormatter);
        }
    }

    public static enum PlainTextFeature {
        INCLUDE_STEPS;

    }
}

