/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.oracle.xstream;

import io.debezium.connector.oracle.BaseChangeRecordEmitter;
import io.debezium.connector.oracle.OracleConnectorConfig;
import io.debezium.connector.oracle.OracleDatabaseSchema;
import io.debezium.data.Envelope;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.relational.Table;
import io.debezium.util.Clock;
import java.util.Map;
import oracle.streams.ColumnValue;
import oracle.streams.RowLCR;

public class XStreamChangeRecordEmitter
extends BaseChangeRecordEmitter<ColumnValue> {
    private final RowLCR lcr;

    public XStreamChangeRecordEmitter(OracleConnectorConfig connectorConfig, Partition partition, OffsetContext offset, RowLCR lcr, Map<String, Object> oldChunkValues, Map<String, Object> newChunkValues, Table table, OracleDatabaseSchema schema, Clock clock) {
        super(connectorConfig, partition, offset, schema, table, clock, XStreamChangeRecordEmitter.getColumnValues(table, lcr.getOldValues(), oldChunkValues), XStreamChangeRecordEmitter.getColumnValues(table, lcr.getNewValues(), newChunkValues));
        this.lcr = lcr;
    }

    public Envelope.Operation getOperation() {
        switch (this.lcr.getCommandType()) {
            case "INSERT": {
                return Envelope.Operation.CREATE;
            }
            case "DELETE": {
                return Envelope.Operation.DELETE;
            }
            case "UPDATE": {
                return Envelope.Operation.UPDATE;
            }
            case "TRUNCATE TABLE": {
                return Envelope.Operation.TRUNCATE;
            }
        }
        throw new IllegalArgumentException("Received event of unexpected command type: " + this.lcr);
    }

    private static Object[] getColumnValues(Table table, ColumnValue[] columnValues, Map<String, Object> chunkValues) {
        Object[] values = new Object[table.columns().size()];
        if (columnValues != null) {
            for (ColumnValue columnValue : columnValues) {
                int index = table.columnWithName(columnValue.getColumnName()).position() - 1;
                values[index] = columnValue.getColumnData();
            }
        }
        for (Map.Entry entry : chunkValues.entrySet()) {
            int index = table.columnWithName((String)entry.getKey()).position() - 1;
            values[index] = entry.getValue();
        }
        return values;
    }
}

