/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.text.ParsingException;
import io.debezium.text.Position;
import io.debezium.text.TokenStream;

public class DdlTokenizer
implements TokenStream.Tokenizer {
    public static final int WORD = 1;
    public static final int SYMBOL = 2;
    public static final int DECIMAL = 4;
    public static final int SINGLE_QUOTED_STRING = 8;
    public static final int DOUBLE_QUOTED_STRING = 16;
    public static final int COMMENT = 32;
    public static final int KEYWORD = 64;
    public static final int STATEMENT_KEY = 128;
    public static final int STATEMENT_TERMINATOR = 256;
    private final boolean removeQuotes = true;
    private final boolean useComments;
    private final TokenTypeFunction retypingFunction;

    public DdlTokenizer(boolean useComments) {
        this(useComments, null);
    }

    public DdlTokenizer(boolean useComments, TokenTypeFunction retypingFunction) {
        this.useComments = useComments;
        this.retypingFunction = retypingFunction != null ? retypingFunction : (type, token) -> type;
    }

    public boolean includeComments() {
        return this.useComments;
    }

    protected TokenStream.Tokens adapt(TokenStream.CharacterStream input, TokenStream.Tokens output) {
        return (position, startIndex, endIndex, type) -> output.addToken(position, startIndex, endIndex, this.retypingFunction.typeOf(type, input.substring(startIndex, endIndex).toUpperCase()));
    }

    @Override
    public void tokenize(TokenStream.CharacterStream input, TokenStream.Tokens tokens) throws ParsingException {
        tokens = this.adapt(input, tokens);
        block10: while (input.hasNext()) {
            char c = input.next();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    break;
                }
                case '#': {
                    int startIndex = input.index();
                    Position startPosition = input.position(startIndex);
                    boolean foundLineTerminator = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if (c != '\n' && c != '\r') continue;
                        foundLineTerminator = true;
                        break;
                    }
                    int endIndex = input.index();
                    if (!foundLineTerminator) {
                        ++endIndex;
                    }
                    if (c == '\r' && input.isNext('\n')) {
                        input.next();
                    }
                    if (!this.useComments) continue block10;
                    tokens.addToken(startPosition, startIndex, endIndex, 32);
                    break;
                }
                case '-': {
                    int endIndex;
                    boolean foundLineTerminator;
                    int startIndex = input.index();
                    Position startPosition = input.position(startIndex);
                    if (input.isNext('-')) {
                        foundLineTerminator = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c != '\n' && c != '\r') continue;
                            foundLineTerminator = true;
                            break;
                        }
                        endIndex = input.index();
                        if (!foundLineTerminator) {
                            ++endIndex;
                        }
                        if (c == '\r' && input.isNext('\n')) {
                            input.next();
                        }
                        if (!this.useComments) continue block10;
                        tokens.addToken(startPosition, startIndex, endIndex, 32);
                        break;
                    }
                    tokens.addToken(startPosition, startIndex, startIndex + 1, 2);
                    break;
                }
                case '!': 
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 2);
                    break;
                }
                case '.': {
                    tokens.addToken(input.position(input.index()), input.index(), input.index() + 1, 4);
                    break;
                }
                case '\"': {
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingQuote = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if ((c == '\\' || c == '\"') && input.isNext('\"')) {
                            c = input.next();
                            continue;
                        }
                        if (c != '\"') continue;
                        foundClosingQuote = true;
                        break;
                    }
                    if (!foundClosingQuote) {
                        String msg = "No matching double quote found after at line " + startingPosition.line() + ", column " + startingPosition.column();
                        throw new ParsingException(startingPosition, msg);
                    }
                    int endIndex = input.index() + 1;
                    if (endIndex - startIndex > 1) {
                        ++startIndex;
                        --endIndex;
                    }
                    tokens.addToken(startingPosition, startIndex, endIndex, 16);
                    break;
                }
                case '\'': 
                case '`': 
                case '\u2018': 
                case '\u2019': {
                    char quoteChar = c;
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    boolean foundClosingQuote = false;
                    while (input.hasNext()) {
                        c = input.next();
                        if ((c == '\\' || c == quoteChar) && input.isNext(quoteChar)) {
                            c = input.next();
                            continue;
                        }
                        if (c != quoteChar) continue;
                        foundClosingQuote = true;
                        break;
                    }
                    if (!foundClosingQuote) {
                        String msg = "No matching single quote found after line " + startingPosition.line() + ", column " + startingPosition.column();
                        throw new ParsingException(startingPosition, msg);
                    }
                    int endIndex = input.index() + 1;
                    if (endIndex - startIndex > 1) {
                        ++startIndex;
                        --endIndex;
                    }
                    tokens.addToken(startingPosition, startIndex, endIndex, 8);
                    break;
                }
                case '/': {
                    int endIndex;
                    int startIndex = input.index();
                    Position startingPosition = input.position(startIndex);
                    if (input.isNext('/')) {
                        boolean foundLineTerminator = false;
                        while (input.hasNext()) {
                            c = input.next();
                            if (c != '\n' && c != '\r') continue;
                            foundLineTerminator = true;
                            break;
                        }
                        endIndex = input.index();
                        if (!foundLineTerminator) {
                            ++endIndex;
                        }
                        if (c == '\r' && input.isNext('\n')) {
                            input.next();
                        }
                        if (!this.useComments) continue block10;
                        tokens.addToken(startingPosition, startIndex, endIndex, 32);
                        break;
                    }
                    if (input.isNext('*')) {
                        while (input.hasNext() && !input.isNext('*', '/')) {
                            c = input.next();
                        }
                        if (input.hasNext()) {
                            input.next();
                        }
                        if (input.hasNext()) {
                            input.next();
                        }
                        endIndex = input.index() + 1;
                        if (!this.useComments) continue block10;
                        tokens.addToken(startingPosition, startIndex, endIndex, 32);
                        break;
                    }
                    tokens.addToken(startingPosition, startIndex, startIndex + 1, 2);
                    break;
                }
                default: {
                    int startIndex = input.index();
                    Position startPosition = input.position(startIndex);
                    while (input.hasNext() && !input.isNextWhitespace() && !input.isNextAnyOf("/.-(){}*,;+%?[]!<>|=:'`\u2018\u2019\"\u2019")) {
                        c = input.next();
                    }
                    int endIndex = input.index() + 1;
                    tokens.addToken(startPosition, startIndex, endIndex, 1);
                }
            }
        }
    }

    public static interface TokenTypeFunction {
        public int typeOf(int var1, String var2);
    }
}

