/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.schema;

import io.debezium.relational.Column;
import io.debezium.util.BoundedConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldNameSelector {
    public static FieldNamer defaultSelector(boolean sanitizeFieldNames) {
        return sanitizeFieldNames ? new FieldNameCache(new FieldNameSanitizer(Column::name)) : Column::name;
    }

    private static class FieldNameCache
    implements FieldNamer {
        private final BoundedConcurrentHashMap<Column, String> fieldNames = new BoundedConcurrentHashMap(10000, 10, BoundedConcurrentHashMap.Eviction.LRU);
        private final FieldNamer delegate;

        public FieldNameCache(FieldNamer delegate) {
            this.delegate = delegate;
        }

        @Override
        public String fieldNameFor(Column column) {
            return this.fieldNames.computeIfAbsent(column, this.delegate::fieldNameFor);
        }
    }

    private static class FieldNameSanitizer
    implements FieldNamer {
        private static final Logger LOGGER = LoggerFactory.getLogger(FieldNameSanitizer.class);
        private static final String REPLACEMENT_CHAR = "_";
        private static final String NUMBER_PREFIX = "_";
        private final FieldNamer delegate;

        public FieldNameSanitizer(FieldNamer delegate) {
            this.delegate = delegate;
        }

        @Override
        public String fieldNameFor(Column column) {
            String fieldName = this.delegate.fieldNameFor(column);
            return this.sanitizeColumnName(fieldName);
        }

        private String sanitizeColumnName(String columnName) {
            boolean changed = false;
            StringBuilder sanitizedNameBuilder = new StringBuilder(columnName.length() + 1);
            for (int i = 0; i < columnName.length(); ++i) {
                char c = columnName.charAt(i);
                if (i == 0 && Character.isDigit(c)) {
                    sanitizedNameBuilder.append("_");
                    sanitizedNameBuilder.append(c);
                    changed = true;
                    continue;
                }
                if (!(c == '_' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9')) {
                    sanitizedNameBuilder.append("_");
                    changed = true;
                    continue;
                }
                sanitizedNameBuilder.append(c);
            }
            String sanitizedName = sanitizedNameBuilder.toString();
            if (changed) {
                LOGGER.warn("Field '{}' name potentially not safe for serialization, replaced with '{}'", (Object)columnName, (Object)sanitizedName);
            }
            return sanitizedName;
        }
    }

    @FunctionalInterface
    public static interface FieldNamer {
        public String fieldNameFor(Column var1);
    }
}

