/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.ServiceAccount;
import io.dekorate.deps.kubernetes.api.model.ServiceAccountFluent;
import io.dekorate.deps.kubernetes.api.model.ServiceAccountFluentImpl;

public class ServiceAccountBuilder
extends ServiceAccountFluentImpl<ServiceAccountBuilder>
implements VisitableBuilder<ServiceAccount, ServiceAccountBuilder> {
    ServiceAccountFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceAccountBuilder() {
        this(true);
    }

    public ServiceAccountBuilder(Boolean validationEnabled) {
        this(new ServiceAccount(), validationEnabled);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceAccount(), validationEnabled);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent, ServiceAccount instance) {
        this(fluent, instance, true);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent, ServiceAccount instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        fluent.withImagePullSecrets(instance.getImagePullSecrets());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSecrets(instance.getSecrets());
        this.validationEnabled = validationEnabled;
    }

    public ServiceAccountBuilder(ServiceAccount instance) {
        this(instance, (Boolean)true);
    }

    public ServiceAccountBuilder(ServiceAccount instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
        this.withImagePullSecrets(instance.getImagePullSecrets());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSecrets(instance.getSecrets());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceAccount build() {
        ServiceAccount buildable = new ServiceAccount(this.fluent.getApiVersion(), this.fluent.isAutomountServiceAccountToken(), this.fluent.getImagePullSecrets(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSecrets());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceAccountBuilder that = (ServiceAccountBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

