/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.api.model;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.Volume;
import io.dekorate.deps.kubernetes.api.model.VolumeFluent;
import io.dekorate.deps.kubernetes.api.model.VolumeFluentImpl;

public class VolumeBuilder
extends VolumeFluentImpl<VolumeBuilder>
implements VisitableBuilder<Volume, VolumeBuilder> {
    VolumeFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeBuilder() {
        this(true);
    }

    public VolumeBuilder(Boolean validationEnabled) {
        this(new Volume(), validationEnabled);
    }

    public VolumeBuilder(VolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Volume(), validationEnabled);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance) {
        this(fluent, instance, true);
    }

    public VolumeBuilder(VolumeFluent<?> fluent, Volume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        fluent.withAzureDisk(instance.getAzureDisk());
        fluent.withAzureFile(instance.getAzureFile());
        fluent.withCephfs(instance.getCephfs());
        fluent.withCinder(instance.getCinder());
        fluent.withConfigMap(instance.getConfigMap());
        fluent.withCsi(instance.getCsi());
        fluent.withDownwardAPI(instance.getDownwardAPI());
        fluent.withEmptyDir(instance.getEmptyDir());
        fluent.withFc(instance.getFc());
        fluent.withFlexVolume(instance.getFlexVolume());
        fluent.withFlocker(instance.getFlocker());
        fluent.withGcePersistentDisk(instance.getGcePersistentDisk());
        fluent.withGitRepo(instance.getGitRepo());
        fluent.withGlusterfs(instance.getGlusterfs());
        fluent.withHostPath(instance.getHostPath());
        fluent.withIscsi(instance.getIscsi());
        fluent.withName(instance.getName());
        fluent.withNfs(instance.getNfs());
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        fluent.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
        fluent.withPortworxVolume(instance.getPortworxVolume());
        fluent.withProjected(instance.getProjected());
        fluent.withQuobyte(instance.getQuobyte());
        fluent.withRbd(instance.getRbd());
        fluent.withScaleIO(instance.getScaleIO());
        fluent.withSecret(instance.getSecret());
        fluent.withStorageos(instance.getStorageos());
        fluent.withVsphereVolume(instance.getVsphereVolume());
        this.validationEnabled = validationEnabled;
    }

    public VolumeBuilder(Volume instance) {
        this(instance, (Boolean)true);
    }

    public VolumeBuilder(Volume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
        this.withAzureDisk(instance.getAzureDisk());
        this.withAzureFile(instance.getAzureFile());
        this.withCephfs(instance.getCephfs());
        this.withCinder(instance.getCinder());
        this.withConfigMap(instance.getConfigMap());
        this.withCsi(instance.getCsi());
        this.withDownwardAPI(instance.getDownwardAPI());
        this.withEmptyDir(instance.getEmptyDir());
        this.withFc(instance.getFc());
        this.withFlexVolume(instance.getFlexVolume());
        this.withFlocker(instance.getFlocker());
        this.withGcePersistentDisk(instance.getGcePersistentDisk());
        this.withGitRepo(instance.getGitRepo());
        this.withGlusterfs(instance.getGlusterfs());
        this.withHostPath(instance.getHostPath());
        this.withIscsi(instance.getIscsi());
        this.withName(instance.getName());
        this.withNfs(instance.getNfs());
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
        this.withPortworxVolume(instance.getPortworxVolume());
        this.withProjected(instance.getProjected());
        this.withQuobyte(instance.getQuobyte());
        this.withRbd(instance.getRbd());
        this.withScaleIO(instance.getScaleIO());
        this.withSecret(instance.getSecret());
        this.withStorageos(instance.getStorageos());
        this.withVsphereVolume(instance.getVsphereVolume());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Volume build() {
        Volume buildable = new Volume(this.fluent.getAwsElasticBlockStore(), this.fluent.getAzureDisk(), this.fluent.getAzureFile(), this.fluent.getCephfs(), this.fluent.getCinder(), this.fluent.getConfigMap(), this.fluent.getCsi(), this.fluent.getDownwardAPI(), this.fluent.getEmptyDir(), this.fluent.getFc(), this.fluent.getFlexVolume(), this.fluent.getFlocker(), this.fluent.getGcePersistentDisk(), this.fluent.getGitRepo(), this.fluent.getGlusterfs(), this.fluent.getHostPath(), this.fluent.getIscsi(), this.fluent.getName(), this.fluent.getNfs(), this.fluent.getPersistentVolumeClaim(), this.fluent.getPhotonPersistentDisk(), this.fluent.getPortworxVolume(), this.fluent.getProjected(), this.fluent.getQuobyte(), this.fluent.getRbd(), this.fluent.getScaleIO(), this.fluent.getSecret(), this.fluent.getStorageos(), this.fluent.getVsphereVolume());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VolumeBuilder that = (VolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

