/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.storage.v1beta1.CSINode;
import io.dekorate.deps.kubernetes.api.model.storage.v1beta1.CSINodeBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.internal.CSINodeOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class CSINodeHandler
implements ResourceHandler<CSINode, CSINodeBuilder> {
    @Override
    public String getKind() {
        return CSINode.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "storage.k8s.io/v1beta1";
    }

    @Override
    public CSINode create(OkHttpClient client, Config config, String namespace, CSINode item) {
        return (CSINode)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new CSINode[0]);
    }

    @Override
    public CSINode replace(OkHttpClient client, Config config, String namespace, CSINode item) {
        return (CSINode)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public CSINode reload(OkHttpClient client, Config config, String namespace, CSINode item) {
        return (CSINode)((Gettable)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public CSINodeBuilder edit(CSINode item) {
        return new CSINodeBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, CSINode item) {
        return (Boolean)new CSINodeOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, Watcher<CSINode> watcher) {
        return (Watch)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, CSINode item, String resourceVersion, Watcher<CSINode> watcher) {
        return (Watch)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public CSINode waitUntilReady(OkHttpClient client, Config config, String namespace, CSINode item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CSINode)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public CSINode waitUntilCondition(OkHttpClient client, Config config, String namespace, CSINode item, Predicate<CSINode> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (CSINode)((Resource)new CSINodeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

