/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.handlers;

import io.dekorate.deps.kubernetes.api.model.apps.StatefulSet;
import io.dekorate.deps.kubernetes.api.model.apps.StatefulSetBuilder;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.RollableScalableResource;
import io.dekorate.deps.kubernetes.client.dsl.internal.StatefulSetOperationsImpl;
import io.dekorate.deps.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class StatefulSetHandler
implements ResourceHandler<StatefulSet, StatefulSetBuilder> {
    @Override
    public String getKind() {
        return StatefulSet.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps/v1";
    }

    @Override
    public StatefulSet create(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new StatefulSet[0]);
    }

    @Override
    public StatefulSet replace(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public StatefulSet reload(OkHttpClient client, Config config, String namespace, StatefulSet item) {
        return (StatefulSet)((Gettable)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public StatefulSetBuilder edit(StatefulSet item) {
        return new StatefulSetBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, StatefulSet item) {
        return (Boolean)new StatefulSetOperationsImpl(client, config, namespace).withItem(item).cascading(cascading).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, Watcher<StatefulSet> watcher) {
        return (Watch)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, StatefulSet item, String resourceVersion, Watcher<StatefulSet> watcher) {
        return (Watch)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public StatefulSet waitUntilReady(OkHttpClient client, Config config, String namespace, StatefulSet item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public StatefulSet waitUntilCondition(OkHttpClient client, Config config, String namespace, StatefulSet item, Predicate<StatefulSet> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (StatefulSet)((RollableScalableResource)new StatefulSetOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

