/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.kubernetes.client.utils;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.RequestConfig;
import io.dekorate.deps.kubernetes.client.utils.Utils;
import io.dekorate.deps.okhttp3.Interceptor;
import io.dekorate.deps.okhttp3.Request;
import io.dekorate.deps.okhttp3.Response;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ImpersonatorInterceptor
implements Interceptor {
    private final Config config;

    public ImpersonatorInterceptor(Config config) {
        this.config = config;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestConfig requestConfig = this.config.getRequestConfig();
        if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateUsername())) {
            Map<String, List<String>> impersonateExtras;
            Request.Builder requestBuilder = chain.request().newBuilder();
            requestBuilder.addHeader("Impersonate-User", requestConfig.getImpersonateUsername());
            String[] impersonateGroups = requestConfig.getImpersonateGroups();
            if (Utils.isNotNullOrEmpty(impersonateGroups)) {
                for (String string : impersonateGroups) {
                    requestBuilder.addHeader("Impersonate-Group", string);
                }
            }
            if (Utils.isNotNullOrEmpty(impersonateExtras = requestConfig.getImpersonateExtras())) {
                Set<String> keys = impersonateExtras.keySet();
                for (Object e : keys) {
                    List<String> values = impersonateExtras.get(e);
                    if (values == null) continue;
                    for (String value : values) {
                        requestBuilder.addHeader("Impersonate-Extra-" + e, value);
                    }
                }
            }
            request = requestBuilder.build();
        }
        return chain.proceed(request);
    }
}

