/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.api.model;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.openshift.api.model.RouteIngress;
import io.dekorate.deps.openshift.api.model.RouteIngressFluent;
import io.dekorate.deps.openshift.api.model.RouteIngressFluentImpl;

public class RouteIngressBuilder
extends RouteIngressFluentImpl<RouteIngressBuilder>
implements VisitableBuilder<RouteIngress, RouteIngressBuilder> {
    RouteIngressFluent<?> fluent;
    Boolean validationEnabled;

    public RouteIngressBuilder() {
        this(true);
    }

    public RouteIngressBuilder(Boolean validationEnabled) {
        this(new RouteIngress(), validationEnabled);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new RouteIngress(), validationEnabled);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent, RouteIngress instance) {
        this(fluent, instance, true);
    }

    public RouteIngressBuilder(RouteIngressFluent<?> fluent, RouteIngress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withHost(instance.getHost());
        fluent.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
        fluent.withRouterName(instance.getRouterName());
        fluent.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    public RouteIngressBuilder(RouteIngress instance) {
        this(instance, (Boolean)true);
    }

    public RouteIngressBuilder(RouteIngress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withHost(instance.getHost());
        this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
        this.withRouterName(instance.getRouterName());
        this.withWildcardPolicy(instance.getWildcardPolicy());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public RouteIngress build() {
        RouteIngress buildable = new RouteIngress(this.fluent.getConditions(), this.fluent.getHost(), this.fluent.getRouterCanonicalHostname(), this.fluent.getRouterName(), this.fluent.getWildcardPolicy());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RouteIngressBuilder that = (RouteIngressBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

