/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client.dsl.internal;

import io.dekorate.deps.kubernetes.api.model.Doneable;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesResourceList;
import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.KubernetesClientException;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.kubernetes.client.dsl.base.HasMetadataOperation;
import io.dekorate.deps.kubernetes.client.dsl.base.OperationContext;
import io.dekorate.deps.kubernetes.client.utils.URLUtils;
import io.dekorate.deps.kubernetes.client.utils.Utils;
import io.dekorate.deps.openshift.client.OpenShiftConfig;
import io.dekorate.deps.openshift.client.OpenShiftConfigBuilder;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList, D extends Doneable<T>, R extends Resource<T, D>>
extends HasMetadataOperation<T, L, D, R> {
    public OpenShiftOperation(OperationContext ctx) {
        super(OpenShiftOperation.wrap(ctx));
    }

    private static OperationContext wrap(OperationContext context) {
        OpenShiftConfig config = OpenShiftConfig.wrap(context.getConfig());
        String oapiVersion = config.getOapiVersion();
        if (Utils.isNotNullOrEmpty(context.getApiGroupName())) {
            if (config.isOpenshiftApiGroupsEnabled()) {
                String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "apis", context.getApiGroupName(), oapiVersion);
                String apiGroupVersion = URLUtils.join(context.getApiGroupName(), oapiVersion);
                return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(apiGroupVersion);
            }
            String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
            return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(oapiVersion);
        }
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupVersion(oapiVersion);
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    @Override
    public URL getRootUrl() {
        if (Utils.isNullOrEmpty(this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        return super.getRootUrl();
    }

    @Override
    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

