/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.openshift.client.handlers;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.kubernetes.client.dsl.Resource;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.openshift.api.model.Identity;
import io.dekorate.deps.openshift.api.model.IdentityBuilder;
import io.dekorate.deps.openshift.client.OpenShiftConfig;
import io.dekorate.deps.openshift.client.dsl.internal.IdentityOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class IdentityHandler
implements ResourceHandler<Identity, IdentityBuilder> {
    @Override
    public String getKind() {
        return Identity.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "user.openshift.io/v1";
    }

    @Override
    public Identity create(OkHttpClient client, Config config, String namespace, Identity item) {
        return (Identity)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new Identity[0]);
    }

    @Override
    public Identity replace(OkHttpClient client, Config config, String namespace, Identity item) {
        return (Identity)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Identity reload(OkHttpClient client, Config config, String namespace, Identity item) {
        return (Identity)((Gettable)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public IdentityBuilder edit(Identity item) {
        return new IdentityBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Identity item) {
        if (cascading.booleanValue()) {
            return (Boolean)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).cascading(true).delete();
        }
        return (Boolean)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, Watcher<Identity> watcher) {
        return (Watch)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Identity item, String resourceVersion, Watcher<Identity> watcher) {
        return (Watch)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Identity waitUntilReady(OkHttpClient client, Config config, String namespace, Identity item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Identity)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Identity waitUntilCondition(OkHttpClient client, Config config, String namespace, Identity item, Predicate<Identity> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Identity)((Resource)new IdentityOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

