/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.deps.servicecatalog.client.handlers;

import io.dekorate.deps.kubernetes.client.Config;
import io.dekorate.deps.kubernetes.client.ResourceHandler;
import io.dekorate.deps.kubernetes.client.Watch;
import io.dekorate.deps.kubernetes.client.Watcher;
import io.dekorate.deps.kubernetes.client.dsl.Gettable;
import io.dekorate.deps.okhttp3.OkHttpClient;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstance;
import io.dekorate.deps.servicecatalog.api.model.ServiceInstanceBuilder;
import io.dekorate.deps.servicecatalog.client.internal.ServiceInstanceOperationsImpl;
import io.dekorate.deps.servicecatalog.client.internal.ServiceInstanceResource;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class ServiceInstanceHandler
implements ResourceHandler<ServiceInstance, ServiceInstanceBuilder> {
    @Override
    public String getKind() {
        return ServiceInstance.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "servicecatalog.k8s.io/v1beta1";
    }

    @Override
    public ServiceInstance create(OkHttpClient client, Config config, String namespace, ServiceInstance item) {
        return (ServiceInstance)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new ServiceInstance[0]);
    }

    @Override
    public ServiceInstance replace(OkHttpClient client, Config config, String namespace, ServiceInstance item) {
        return (ServiceInstance)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public ServiceInstance reload(OkHttpClient client, Config config, String namespace, ServiceInstance item) {
        return (ServiceInstance)((Gettable)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ServiceInstanceBuilder edit(ServiceInstance item) {
        return new ServiceInstanceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, ServiceInstance item) {
        return (Boolean)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceInstance item, Watcher<ServiceInstance> watcher) {
        return (Watch)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, ServiceInstance item, String resourceVersion, Watcher<ServiceInstance> watcher) {
        return (Watch)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public ServiceInstance waitUntilReady(OkHttpClient client, Config config, String namespace, ServiceInstance item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceInstance)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public ServiceInstance waitUntilCondition(OkHttpClient client, Config config, String namespace, ServiceInstance item, Predicate<ServiceInstance> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (ServiceInstance)((ServiceInstanceResource)new ServiceInstanceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

