/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.knative.decorator;

import io.dekorate.deps.knative.serving.v1.RevisionSpecFluent;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.kubernetes.api.model.VolumeFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;

@Description(value="Add an Azure File volume to the Pod spec.")
public class AddAzureFileVolumeToRevisionDecorator
extends NamedResourceDecorator<RevisionSpecFluent<?>> {
    private final AzureFileVolume volume;

    public AddAzureFileVolumeToRevisionDecorator(AzureFileVolume volume) {
        this(ANY, volume);
    }

    public AddAzureFileVolumeToRevisionDecorator(String name, AzureFileVolume volume) {
        super(name);
        this.volume = volume;
    }

    public void andThenVisit(RevisionSpecFluent<?> revisionSpec, ObjectMeta resourceMeta) {
        ((RevisionSpecFluent.VolumesNested)((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((VolumeFluent.AzureFileNested)((RevisionSpecFluent.VolumesNested)revisionSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewAzureFile().withSecretName(this.volume.getSecretName())).withShareName(this.volume.getShareName())).withReadOnly(Boolean.valueOf(this.volume.isReadOnly()))).endAzureFile()).endVolume();
    }
}

