/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.ConfigurationFluent;
import io.dekorate.kubernetes.config.ConfigurationFluentImpl;
import io.dekorate.kubernetes.config.EditableConfiguration;
import java.util.Objects;

public class ConfigurationBuilder
extends ConfigurationFluentImpl<ConfigurationBuilder>
implements VisitableBuilder<Configuration, ConfigurationBuilder> {
    ConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigurationBuilder() {
        this(true);
    }

    public ConfigurationBuilder(Boolean validationEnabled) {
        this(new Configuration(), validationEnabled);
    }

    public ConfigurationBuilder(ConfigurationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ConfigurationBuilder(ConfigurationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Configuration(), validationEnabled);
    }

    public ConfigurationBuilder(ConfigurationFluent<?> fluent, Configuration instance) {
        this(fluent, instance, true);
    }

    public ConfigurationBuilder(ConfigurationFluent<?> fluent, Configuration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        this.validationEnabled = validationEnabled;
    }

    public ConfigurationBuilder(Configuration instance) {
        this(instance, (Boolean)true);
    }

    public ConfigurationBuilder(Configuration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.validationEnabled = validationEnabled;
    }

    public EditableConfiguration build() {
        EditableConfiguration buildable = new EditableConfiguration(this.fluent.getProject(), this.fluent.getAttributes());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurationBuilder that = (ConfigurationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

