/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.kubernetes.config.EditableImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationFluent;
import io.dekorate.kubernetes.config.ImageConfigurationFluentImpl;
import java.util.Objects;

public class ImageConfigurationBuilder
extends ImageConfigurationFluentImpl<ImageConfigurationBuilder>
implements VisitableBuilder<ImageConfiguration, ImageConfigurationBuilder> {
    ImageConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public ImageConfigurationBuilder() {
        this(true);
    }

    public ImageConfigurationBuilder(Boolean validationEnabled) {
        this(new ImageConfiguration(), validationEnabled);
    }

    public ImageConfigurationBuilder(ImageConfigurationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ImageConfigurationBuilder(ImageConfigurationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ImageConfiguration(), validationEnabled);
    }

    public ImageConfigurationBuilder(ImageConfigurationFluent<?> fluent, ImageConfiguration instance) {
        this(fluent, instance, true);
    }

    public ImageConfigurationBuilder(ImageConfigurationFluent<?> fluent, ImageConfiguration instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withProject(instance.getProject());
        fluent.withAttributes(instance.getAttributes());
        fluent.withRegistry(instance.getRegistry());
        fluent.withGroup(instance.getGroup());
        fluent.withName(instance.getName());
        fluent.withVersion(instance.getVersion());
        fluent.withImage(instance.getImage());
        fluent.withDockerFile(instance.getDockerFile());
        fluent.withAutoBuildEnabled(instance.isAutoBuildEnabled());
        fluent.withAutoPushEnabled(instance.isAutoPushEnabled());
        this.validationEnabled = validationEnabled;
    }

    public ImageConfigurationBuilder(ImageConfiguration instance) {
        this(instance, (Boolean)true);
    }

    public ImageConfigurationBuilder(ImageConfiguration instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withProject(instance.getProject());
        this.withAttributes(instance.getAttributes());
        this.withRegistry(instance.getRegistry());
        this.withGroup(instance.getGroup());
        this.withName(instance.getName());
        this.withVersion(instance.getVersion());
        this.withImage(instance.getImage());
        this.withDockerFile(instance.getDockerFile());
        this.withAutoBuildEnabled(instance.isAutoBuildEnabled());
        this.withAutoPushEnabled(instance.isAutoPushEnabled());
        this.validationEnabled = validationEnabled;
    }

    public EditableImageConfiguration build() {
        EditableImageConfiguration buildable = new EditableImageConfiguration(this.fluent.getProject(), this.fluent.getAttributes(), this.fluent.getRegistry(), this.fluent.getGroup(), this.fluent.getName(), this.fluent.getVersion(), this.fluent.getImage(), this.fluent.getDockerFile(), this.fluent.isAutoBuildEnabled(), this.fluent.isAutoPushEnabled());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageConfigurationBuilder that = (ImageConfigurationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

