/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.project.Project;
import io.dekorate.project.ProjectBuilder;
import io.dekorate.project.ProjectFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ConfigurationFluent<A extends ConfigurationFluent<A>>
extends BaseFluent<A> {
    private ProjectBuilder project;
    private Map<ConfigKey, Object> attributes;

    public ConfigurationFluent() {
    }

    public ConfigurationFluent(Configuration instance) {
        Configuration configuration = instance = instance != null ? instance : new Configuration();
        if (instance != null) {
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
            this.withProject(instance.getProject());
            this.withAttributes(instance.getAttributes());
        }
    }

    public Project buildProject() {
        return this.project != null ? this.project.build() : null;
    }

    public A withProject(Project project) {
        this._visitables.get((Object)"project").remove(this.project);
        if (project != null) {
            this.project = new ProjectBuilder(project);
            this._visitables.get((Object)"project").add(this.project);
        } else {
            this.project = null;
            this._visitables.get((Object)"project").remove(this.project);
        }
        return (A)((Object)this);
    }

    public boolean hasProject() {
        return this.project != null;
    }

    public ProjectNested<A> withNewProject() {
        return new ProjectNested(null);
    }

    public ProjectNested<A> withNewProjectLike(Project item) {
        return new ProjectNested(item);
    }

    public ProjectNested<A> editProject() {
        return this.withNewProjectLike(Optional.ofNullable(this.buildProject()).orElse(null));
    }

    public ProjectNested<A> editOrNewProject() {
        return this.withNewProjectLike(Optional.ofNullable(this.buildProject()).orElse((Project)new ProjectBuilder().build()));
    }

    public ProjectNested<A> editOrNewProjectLike(Project item) {
        return this.withNewProjectLike(Optional.ofNullable(this.buildProject()).orElse(item));
    }

    public A addToAttributes(ConfigKey key, Object value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<ConfigKey, Object>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAttributes(Map<ConfigKey, Object> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<ConfigKey, Object>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAttributes(ConfigKey key) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAttributes(Map<ConfigKey, Object> map) {
        if (this.attributes == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (ConfigKey key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<ConfigKey, Object> getAttributes() {
        return this.attributes;
    }

    public <K, V> A withAttributes(Map<ConfigKey, Object> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<ConfigKey, Object>(attributes);
        return (A)((Object)this);
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConfigurationFluent that = (ConfigurationFluent)((Object)o);
        if (!Objects.equals(this.project, that.project)) {
            return false;
        }
        return Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.project, this.attributes, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.project != null) {
            sb.append("project:");
            sb.append(this.project + ",");
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ProjectNested<N>
    extends ProjectFluent<ProjectNested<N>>
    implements Nested<N> {
        ProjectBuilder builder;

        ProjectNested(Project item) {
            this.builder = new ProjectBuilder((ProjectFluent)this, item);
        }

        public N and() {
            return (N)ConfigurationFluent.this.withProject((Project)this.builder.build());
        }

        public N endProject() {
            return this.and();
        }
    }
}

