/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.JobCompletionMode;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeBuilder;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeFluent;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureDiskVolumeBuilder;
import io.dekorate.kubernetes.config.AzureDiskVolumeFluent;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.AzureFileVolumeBuilder;
import io.dekorate.kubernetes.config.AzureFileVolumeFluent;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigMapVolumeBuilder;
import io.dekorate.kubernetes.config.ConfigMapVolumeFluent;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluent;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.EmptyDirVolumeBuilder;
import io.dekorate.kubernetes.config.EmptyDirVolumeFluent;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeFluent;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.dekorate.kubernetes.config.SecretVolumeFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JobFluent<A extends JobFluent<A>>
extends BaseFluent<A> {
    private String name;
    private Integer parallelism;
    private Integer completions;
    private JobCompletionMode completionMode;
    private Integer backoffLimit;
    private Long activeDeadlineSeconds;
    private Integer ttlSecondsAfterFinished;
    private Boolean suspend;
    private JobRestartPolicy restartPolicy;
    private ArrayList<PersistentVolumeClaimVolumeBuilder> pvcVolumes = new ArrayList();
    private ArrayList<SecretVolumeBuilder> secretVolumes = new ArrayList();
    private ArrayList<ConfigMapVolumeBuilder> configMapVolumes = new ArrayList();
    private ArrayList<EmptyDirVolumeBuilder> emptyDirVolumes = new ArrayList();
    private ArrayList<AwsElasticBlockStoreVolumeBuilder> awsElasticBlockStoreVolumes = new ArrayList();
    private ArrayList<AzureDiskVolumeBuilder> azureDiskVolumes = new ArrayList();
    private ArrayList<AzureFileVolumeBuilder> azureFileVolumes = new ArrayList();
    private ArrayList<ContainerBuilder> containers = new ArrayList();

    public JobFluent() {
    }

    public JobFluent(Job instance) {
        Job job = instance = instance != null ? instance : new Job();
        if (instance != null) {
            this.withName(instance.getName());
            this.withParallelism(instance.getParallelism());
            this.withCompletions(instance.getCompletions());
            this.withCompletionMode(instance.getCompletionMode());
            this.withBackoffLimit(instance.getBackoffLimit());
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
            this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
            this.withSuspend(instance.getSuspend());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withPvcVolumes(instance.getPvcVolumes());
            this.withSecretVolumes(instance.getSecretVolumes());
            this.withConfigMapVolumes(instance.getConfigMapVolumes());
            this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
            this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
            this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
            this.withAzureFileVolumes(instance.getAzureFileVolumes());
            this.withContainers(instance.getContainers());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public A withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (A)((Object)this);
    }

    public boolean hasParallelism() {
        return this.parallelism != null;
    }

    public Integer getCompletions() {
        return this.completions;
    }

    public A withCompletions(Integer completions) {
        this.completions = completions;
        return (A)((Object)this);
    }

    public boolean hasCompletions() {
        return this.completions != null;
    }

    public JobCompletionMode getCompletionMode() {
        return this.completionMode;
    }

    public A withCompletionMode(JobCompletionMode completionMode) {
        this.completionMode = completionMode;
        return (A)((Object)this);
    }

    public boolean hasCompletionMode() {
        return this.completionMode != null;
    }

    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)((Object)this);
    }

    public boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)((Object)this);
    }

    public boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)((Object)this);
    }

    public boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    public Boolean getSuspend() {
        return this.suspend;
    }

    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)((Object)this);
    }

    public boolean hasSuspend() {
        return this.suspend != null;
    }

    public JobRestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(JobRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)((Object)this);
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public A withPvcVolumes(PersistentVolumeClaimVolume ... pvcVolumes) {
        if (this.pvcVolumes != null) {
            this.pvcVolumes.clear();
            this._visitables.remove((Object)"pvcVolumes");
        }
        if (pvcVolumes != null) {
            for (PersistentVolumeClaimVolume item : pvcVolumes) {
                this.addToPvcVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public PersistentVolumeClaimVolume[] buildPvcVolumes() {
        int size = this.pvcVolumes != null ? this.pvcVolumes.size() : 0;
        PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.pvcVolumes) {
            result[index++] = (PersistentVolumeClaimVolume)visitableBuilder.build();
        }
        return result;
    }

    public PersistentVolumeClaimVolume buildPvcVolume(int index) {
        return this.pvcVolumes.get(index).build();
    }

    public PersistentVolumeClaimVolume buildFirstPvcVolume() {
        return this.pvcVolumes.get(0).build();
    }

    public PersistentVolumeClaimVolume buildLastPvcVolume() {
        return this.pvcVolumes.get(this.pvcVolumes.size() - 1).build();
    }

    public PersistentVolumeClaimVolume buildMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToPvcVolumes(int index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        if (index < 0 || index >= this.pvcVolumes.size()) {
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        } else {
            this._visitables.get((Object)"pvcVolumes").add(index, builder);
            this.pvcVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToPvcVolumes(int index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        if (index < 0 || index >= this.pvcVolumes.size()) {
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        } else {
            this._visitables.get((Object)"pvcVolumes").set(index, builder);
            this.pvcVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToPvcVolumes(PersistentVolumeClaimVolume ... items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromPvcVolumes(PersistentVolumeClaimVolume ... items) {
        if (this.pvcVolumes == null) {
            return (A)((Object)this);
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove((Object)builder);
            this.pvcVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        if (this.pvcVolumes == null) {
            return (A)((Object)this);
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove((Object)builder);
            this.pvcVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromPvcVolumes(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        if (this.pvcVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<PersistentVolumeClaimVolumeBuilder> each = this.pvcVolumes.iterator();
        List visitables = this._visitables.get((Object)"pvcVolumes");
        while (each.hasNext()) {
            PersistentVolumeClaimVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasPvcVolumes() {
        return this.pvcVolumes != null && !this.pvcVolumes.isEmpty();
    }

    public A addNewPvcVolume(String volumeName, String claimName, Boolean readOnly) {
        return this.addToPvcVolumes(new PersistentVolumeClaimVolume(volumeName, claimName, readOnly));
    }

    public PvcVolumesNested<A> addNewPvcVolume() {
        return new PvcVolumesNested(-1, null);
    }

    public PvcVolumesNested<A> addNewPvcVolumeLike(PersistentVolumeClaimVolume item) {
        return new PvcVolumesNested(-1, item);
    }

    public PvcVolumesNested<A> setNewPvcVolumeLike(int index, PersistentVolumeClaimVolume item) {
        return new PvcVolumesNested(index, item);
    }

    public PvcVolumesNested<A> editPvcVolume(int index) {
        if (this.pvcVolumes.size() <= index) {
            throw new RuntimeException("Can't edit pvcVolumes. Index exceeds size.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    public PvcVolumesNested<A> editFirstPvcVolume() {
        if (this.pvcVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(0, this.buildPvcVolume(0));
    }

    public PvcVolumesNested<A> editLastPvcVolume() {
        int index = this.pvcVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    public PvcVolumesNested<A> editMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pvcVolumes.size(); ++i) {
            if (!predicate.test(this.pvcVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pvcVolumes. No match found.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    public A withSecretVolumes(SecretVolume ... secretVolumes) {
        if (this.secretVolumes != null) {
            this.secretVolumes.clear();
            this._visitables.remove((Object)"secretVolumes");
        }
        if (secretVolumes != null) {
            for (SecretVolume item : secretVolumes) {
                this.addToSecretVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public SecretVolume[] buildSecretVolumes() {
        int size = this.secretVolumes != null ? this.secretVolumes.size() : 0;
        SecretVolume[] result = new SecretVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.secretVolumes) {
            result[index++] = (SecretVolume)visitableBuilder.build();
        }
        return result;
    }

    public SecretVolume buildSecretVolume(int index) {
        return this.secretVolumes.get(index).build();
    }

    public SecretVolume buildFirstSecretVolume() {
        return this.secretVolumes.get(0).build();
    }

    public SecretVolume buildLastSecretVolume() {
        return this.secretVolumes.get(this.secretVolumes.size() - 1).build();
    }

    public SecretVolume buildMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToSecretVolumes(int index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        if (index < 0 || index >= this.secretVolumes.size()) {
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        } else {
            this._visitables.get((Object)"secretVolumes").add(index, builder);
            this.secretVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSecretVolumes(int index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        if (index < 0 || index >= this.secretVolumes.size()) {
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        } else {
            this._visitables.get((Object)"secretVolumes").set(index, builder);
            this.secretVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSecretVolumes(SecretVolume ... items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSecretVolumes(Collection<SecretVolume> items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSecretVolumes(SecretVolume ... items) {
        if (this.secretVolumes == null) {
            return (A)((Object)this);
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove((Object)builder);
            this.secretVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSecretVolumes(Collection<SecretVolume> items) {
        if (this.secretVolumes == null) {
            return (A)((Object)this);
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove((Object)builder);
            this.secretVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSecretVolumes(Predicate<SecretVolumeBuilder> predicate) {
        if (this.secretVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<SecretVolumeBuilder> each = this.secretVolumes.iterator();
        List visitables = this._visitables.get((Object)"secretVolumes");
        while (each.hasNext()) {
            SecretVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasSecretVolumes() {
        return this.secretVolumes != null && !this.secretVolumes.isEmpty();
    }

    public SecretVolumesNested<A> addNewSecretVolume() {
        return new SecretVolumesNested(-1, null);
    }

    public SecretVolumesNested<A> addNewSecretVolumeLike(SecretVolume item) {
        return new SecretVolumesNested(-1, item);
    }

    public SecretVolumesNested<A> setNewSecretVolumeLike(int index, SecretVolume item) {
        return new SecretVolumesNested(index, item);
    }

    public SecretVolumesNested<A> editSecretVolume(int index) {
        if (this.secretVolumes.size() <= index) {
            throw new RuntimeException("Can't edit secretVolumes. Index exceeds size.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    public SecretVolumesNested<A> editFirstSecretVolume() {
        if (this.secretVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(0, this.buildSecretVolume(0));
    }

    public SecretVolumesNested<A> editLastSecretVolume() {
        int index = this.secretVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    public SecretVolumesNested<A> editMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretVolumes.size(); ++i) {
            if (!predicate.test(this.secretVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretVolumes. No match found.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    public A withConfigMapVolumes(ConfigMapVolume ... configMapVolumes) {
        if (this.configMapVolumes != null) {
            this.configMapVolumes.clear();
            this._visitables.remove((Object)"configMapVolumes");
        }
        if (configMapVolumes != null) {
            for (ConfigMapVolume item : configMapVolumes) {
                this.addToConfigMapVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public ConfigMapVolume[] buildConfigMapVolumes() {
        int size = this.configMapVolumes != null ? this.configMapVolumes.size() : 0;
        ConfigMapVolume[] result = new ConfigMapVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.configMapVolumes) {
            result[index++] = (ConfigMapVolume)visitableBuilder.build();
        }
        return result;
    }

    public ConfigMapVolume buildConfigMapVolume(int index) {
        return this.configMapVolumes.get(index).build();
    }

    public ConfigMapVolume buildFirstConfigMapVolume() {
        return this.configMapVolumes.get(0).build();
    }

    public ConfigMapVolume buildLastConfigMapVolume() {
        return this.configMapVolumes.get(this.configMapVolumes.size() - 1).build();
    }

    public ConfigMapVolume buildMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToConfigMapVolumes(int index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        if (index < 0 || index >= this.configMapVolumes.size()) {
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        } else {
            this._visitables.get((Object)"configMapVolumes").add(index, builder);
            this.configMapVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToConfigMapVolumes(int index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        if (index < 0 || index >= this.configMapVolumes.size()) {
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        } else {
            this._visitables.get((Object)"configMapVolumes").set(index, builder);
            this.configMapVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToConfigMapVolumes(ConfigMapVolume ... items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToConfigMapVolumes(Collection<ConfigMapVolume> items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromConfigMapVolumes(ConfigMapVolume ... items) {
        if (this.configMapVolumes == null) {
            return (A)((Object)this);
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove((Object)builder);
            this.configMapVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConfigMapVolumes(Collection<ConfigMapVolume> items) {
        if (this.configMapVolumes == null) {
            return (A)((Object)this);
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove((Object)builder);
            this.configMapVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromConfigMapVolumes(Predicate<ConfigMapVolumeBuilder> predicate) {
        if (this.configMapVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<ConfigMapVolumeBuilder> each = this.configMapVolumes.iterator();
        List visitables = this._visitables.get((Object)"configMapVolumes");
        while (each.hasNext()) {
            ConfigMapVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasConfigMapVolumes() {
        return this.configMapVolumes != null && !this.configMapVolumes.isEmpty();
    }

    public ConfigMapVolumesNested<A> addNewConfigMapVolume() {
        return new ConfigMapVolumesNested(-1, null);
    }

    public ConfigMapVolumesNested<A> addNewConfigMapVolumeLike(ConfigMapVolume item) {
        return new ConfigMapVolumesNested(-1, item);
    }

    public ConfigMapVolumesNested<A> setNewConfigMapVolumeLike(int index, ConfigMapVolume item) {
        return new ConfigMapVolumesNested(index, item);
    }

    public ConfigMapVolumesNested<A> editConfigMapVolume(int index) {
        if (this.configMapVolumes.size() <= index) {
            throw new RuntimeException("Can't edit configMapVolumes. Index exceeds size.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    public ConfigMapVolumesNested<A> editFirstConfigMapVolume() {
        if (this.configMapVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(0, this.buildConfigMapVolume(0));
    }

    public ConfigMapVolumesNested<A> editLastConfigMapVolume() {
        int index = this.configMapVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    public ConfigMapVolumesNested<A> editMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configMapVolumes.size(); ++i) {
            if (!predicate.test(this.configMapVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configMapVolumes. No match found.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    public A withEmptyDirVolumes(EmptyDirVolume ... emptyDirVolumes) {
        if (this.emptyDirVolumes != null) {
            this.emptyDirVolumes.clear();
            this._visitables.remove((Object)"emptyDirVolumes");
        }
        if (emptyDirVolumes != null) {
            for (EmptyDirVolume item : emptyDirVolumes) {
                this.addToEmptyDirVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public EmptyDirVolume[] buildEmptyDirVolumes() {
        int size = this.emptyDirVolumes != null ? this.emptyDirVolumes.size() : 0;
        EmptyDirVolume[] result = new EmptyDirVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.emptyDirVolumes) {
            result[index++] = (EmptyDirVolume)visitableBuilder.build();
        }
        return result;
    }

    public EmptyDirVolume buildEmptyDirVolume(int index) {
        return this.emptyDirVolumes.get(index).build();
    }

    public EmptyDirVolume buildFirstEmptyDirVolume() {
        return this.emptyDirVolumes.get(0).build();
    }

    public EmptyDirVolume buildLastEmptyDirVolume() {
        return this.emptyDirVolumes.get(this.emptyDirVolumes.size() - 1).build();
    }

    public EmptyDirVolume buildMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToEmptyDirVolumes(int index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        if (index < 0 || index >= this.emptyDirVolumes.size()) {
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        } else {
            this._visitables.get((Object)"emptyDirVolumes").add(index, builder);
            this.emptyDirVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToEmptyDirVolumes(int index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        if (index < 0 || index >= this.emptyDirVolumes.size()) {
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        } else {
            this._visitables.get((Object)"emptyDirVolumes").set(index, builder);
            this.emptyDirVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToEmptyDirVolumes(EmptyDirVolume ... items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromEmptyDirVolumes(EmptyDirVolume ... items) {
        if (this.emptyDirVolumes == null) {
            return (A)((Object)this);
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove((Object)builder);
            this.emptyDirVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        if (this.emptyDirVolumes == null) {
            return (A)((Object)this);
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove((Object)builder);
            this.emptyDirVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromEmptyDirVolumes(Predicate<EmptyDirVolumeBuilder> predicate) {
        if (this.emptyDirVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<EmptyDirVolumeBuilder> each = this.emptyDirVolumes.iterator();
        List visitables = this._visitables.get((Object)"emptyDirVolumes");
        while (each.hasNext()) {
            EmptyDirVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasEmptyDirVolumes() {
        return this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty();
    }

    public A addNewEmptyDirVolume(String volumeName) {
        return this.addToEmptyDirVolumes(new EmptyDirVolume(volumeName));
    }

    public EmptyDirVolumesNested<A> addNewEmptyDirVolume() {
        return new EmptyDirVolumesNested(-1, null);
    }

    public EmptyDirVolumesNested<A> addNewEmptyDirVolumeLike(EmptyDirVolume item) {
        return new EmptyDirVolumesNested(-1, item);
    }

    public EmptyDirVolumesNested<A> setNewEmptyDirVolumeLike(int index, EmptyDirVolume item) {
        return new EmptyDirVolumesNested(index, item);
    }

    public EmptyDirVolumesNested<A> editEmptyDirVolume(int index) {
        if (this.emptyDirVolumes.size() <= index) {
            throw new RuntimeException("Can't edit emptyDirVolumes. Index exceeds size.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    public EmptyDirVolumesNested<A> editFirstEmptyDirVolume() {
        if (this.emptyDirVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(0, this.buildEmptyDirVolume(0));
    }

    public EmptyDirVolumesNested<A> editLastEmptyDirVolume() {
        int index = this.emptyDirVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    public EmptyDirVolumesNested<A> editMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.emptyDirVolumes.size(); ++i) {
            if (!predicate.test(this.emptyDirVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching emptyDirVolumes. No match found.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    public A withAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... awsElasticBlockStoreVolumes) {
        if (this.awsElasticBlockStoreVolumes != null) {
            this.awsElasticBlockStoreVolumes.clear();
            this._visitables.remove((Object)"awsElasticBlockStoreVolumes");
        }
        if (awsElasticBlockStoreVolumes != null) {
            for (AwsElasticBlockStoreVolume item : awsElasticBlockStoreVolumes) {
                this.addToAwsElasticBlockStoreVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public AwsElasticBlockStoreVolume[] buildAwsElasticBlockStoreVolumes() {
        int size = this.awsElasticBlockStoreVolumes != null ? this.awsElasticBlockStoreVolumes.size() : 0;
        AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.awsElasticBlockStoreVolumes) {
            result[index++] = (AwsElasticBlockStoreVolume)visitableBuilder.build();
        }
        return result;
    }

    public AwsElasticBlockStoreVolume buildAwsElasticBlockStoreVolume(int index) {
        return this.awsElasticBlockStoreVolumes.get(index).build();
    }

    public AwsElasticBlockStoreVolume buildFirstAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(0).build();
    }

    public AwsElasticBlockStoreVolume buildLastAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(this.awsElasticBlockStoreVolumes.size() - 1).build();
    }

    public AwsElasticBlockStoreVolume buildMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAwsElasticBlockStoreVolumes(int index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        if (index < 0 || index >= this.awsElasticBlockStoreVolumes.size()) {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        } else {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(index, builder);
            this.awsElasticBlockStoreVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAwsElasticBlockStoreVolumes(int index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        if (index < 0 || index >= this.awsElasticBlockStoreVolumes.size()) {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        } else {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").set(index, builder);
            this.awsElasticBlockStoreVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)((Object)this);
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove((Object)builder);
            this.awsElasticBlockStoreVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)((Object)this);
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove((Object)builder);
            this.awsElasticBlockStoreVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAwsElasticBlockStoreVolumes(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<AwsElasticBlockStoreVolumeBuilder> each = this.awsElasticBlockStoreVolumes.iterator();
        List visitables = this._visitables.get((Object)"awsElasticBlockStoreVolumes");
        while (each.hasNext()) {
            AwsElasticBlockStoreVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty();
    }

    public A addNewAwsElasticBlockStoreVolume(String volumeName, String volumeId, Integer partition, String fsType, Boolean readOnly) {
        return this.addToAwsElasticBlockStoreVolumes(new AwsElasticBlockStoreVolume(volumeName, volumeId, partition, fsType, readOnly));
    }

    public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolume() {
        return new AwsElasticBlockStoreVolumesNested(-1, null);
    }

    public AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolumeLike(AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNested(-1, item);
    }

    public AwsElasticBlockStoreVolumesNested<A> setNewAwsElasticBlockStoreVolumeLike(int index, AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNested(index, item);
    }

    public AwsElasticBlockStoreVolumesNested<A> editAwsElasticBlockStoreVolume(int index) {
        if (this.awsElasticBlockStoreVolumes.size() <= index) {
            throw new RuntimeException("Can't edit awsElasticBlockStoreVolumes. Index exceeds size.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    public AwsElasticBlockStoreVolumesNested<A> editFirstAwsElasticBlockStoreVolume() {
        if (this.awsElasticBlockStoreVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(0, this.buildAwsElasticBlockStoreVolume(0));
    }

    public AwsElasticBlockStoreVolumesNested<A> editLastAwsElasticBlockStoreVolume() {
        int index = this.awsElasticBlockStoreVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    public AwsElasticBlockStoreVolumesNested<A> editMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.awsElasticBlockStoreVolumes.size(); ++i) {
            if (!predicate.test(this.awsElasticBlockStoreVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching awsElasticBlockStoreVolumes. No match found.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    public A withAzureDiskVolumes(AzureDiskVolume ... azureDiskVolumes) {
        if (this.azureDiskVolumes != null) {
            this.azureDiskVolumes.clear();
            this._visitables.remove((Object)"azureDiskVolumes");
        }
        if (azureDiskVolumes != null) {
            for (AzureDiskVolume item : azureDiskVolumes) {
                this.addToAzureDiskVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public AzureDiskVolume[] buildAzureDiskVolumes() {
        int size = this.azureDiskVolumes != null ? this.azureDiskVolumes.size() : 0;
        AzureDiskVolume[] result = new AzureDiskVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureDiskVolumes) {
            result[index++] = (AzureDiskVolume)visitableBuilder.build();
        }
        return result;
    }

    public AzureDiskVolume buildAzureDiskVolume(int index) {
        return this.azureDiskVolumes.get(index).build();
    }

    public AzureDiskVolume buildFirstAzureDiskVolume() {
        return this.azureDiskVolumes.get(0).build();
    }

    public AzureDiskVolume buildLastAzureDiskVolume() {
        return this.azureDiskVolumes.get(this.azureDiskVolumes.size() - 1).build();
    }

    public AzureDiskVolume buildMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAzureDiskVolumes(int index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        if (index < 0 || index >= this.azureDiskVolumes.size()) {
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureDiskVolumes").add(index, builder);
            this.azureDiskVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAzureDiskVolumes(int index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        if (index < 0 || index >= this.azureDiskVolumes.size()) {
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureDiskVolumes").set(index, builder);
            this.azureDiskVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAzureDiskVolumes(AzureDiskVolume ... items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAzureDiskVolumes(AzureDiskVolume ... items) {
        if (this.azureDiskVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove((Object)builder);
            this.azureDiskVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        if (this.azureDiskVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove((Object)builder);
            this.azureDiskVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAzureDiskVolumes(Predicate<AzureDiskVolumeBuilder> predicate) {
        if (this.azureDiskVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<AzureDiskVolumeBuilder> each = this.azureDiskVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureDiskVolumes");
        while (each.hasNext()) {
            AzureDiskVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAzureDiskVolumes() {
        return this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty();
    }

    public AzureDiskVolumesNested<A> addNewAzureDiskVolume() {
        return new AzureDiskVolumesNested(-1, null);
    }

    public AzureDiskVolumesNested<A> addNewAzureDiskVolumeLike(AzureDiskVolume item) {
        return new AzureDiskVolumesNested(-1, item);
    }

    public AzureDiskVolumesNested<A> setNewAzureDiskVolumeLike(int index, AzureDiskVolume item) {
        return new AzureDiskVolumesNested(index, item);
    }

    public AzureDiskVolumesNested<A> editAzureDiskVolume(int index) {
        if (this.azureDiskVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureDiskVolumes. Index exceeds size.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    public AzureDiskVolumesNested<A> editFirstAzureDiskVolume() {
        if (this.azureDiskVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(0, this.buildAzureDiskVolume(0));
    }

    public AzureDiskVolumesNested<A> editLastAzureDiskVolume() {
        int index = this.azureDiskVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    public AzureDiskVolumesNested<A> editMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureDiskVolumes.size(); ++i) {
            if (!predicate.test(this.azureDiskVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureDiskVolumes. No match found.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    public A withAzureFileVolumes(AzureFileVolume ... azureFileVolumes) {
        if (this.azureFileVolumes != null) {
            this.azureFileVolumes.clear();
            this._visitables.remove((Object)"azureFileVolumes");
        }
        if (azureFileVolumes != null) {
            for (AzureFileVolume item : azureFileVolumes) {
                this.addToAzureFileVolumes(item);
            }
        }
        return (A)((Object)this);
    }

    public AzureFileVolume[] buildAzureFileVolumes() {
        int size = this.azureFileVolumes != null ? this.azureFileVolumes.size() : 0;
        AzureFileVolume[] result = new AzureFileVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureFileVolumes) {
            result[index++] = (AzureFileVolume)visitableBuilder.build();
        }
        return result;
    }

    public AzureFileVolume buildAzureFileVolume(int index) {
        return this.azureFileVolumes.get(index).build();
    }

    public AzureFileVolume buildFirstAzureFileVolume() {
        return this.azureFileVolumes.get(0).build();
    }

    public AzureFileVolume buildLastAzureFileVolume() {
        return this.azureFileVolumes.get(this.azureFileVolumes.size() - 1).build();
    }

    public AzureFileVolume buildMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToAzureFileVolumes(int index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        if (index < 0 || index >= this.azureFileVolumes.size()) {
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureFileVolumes").add(index, builder);
            this.azureFileVolumes.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAzureFileVolumes(int index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        if (index < 0 || index >= this.azureFileVolumes.size()) {
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        } else {
            this._visitables.get((Object)"azureFileVolumes").set(index, builder);
            this.azureFileVolumes.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAzureFileVolumes(AzureFileVolume ... items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAzureFileVolumes(Collection<AzureFileVolume> items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAzureFileVolumes(AzureFileVolume ... items) {
        if (this.azureFileVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove((Object)builder);
            this.azureFileVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAzureFileVolumes(Collection<AzureFileVolume> items) {
        if (this.azureFileVolumes == null) {
            return (A)((Object)this);
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove((Object)builder);
            this.azureFileVolumes.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAzureFileVolumes(Predicate<AzureFileVolumeBuilder> predicate) {
        if (this.azureFileVolumes == null) {
            return (A)((Object)this);
        }
        Iterator<AzureFileVolumeBuilder> each = this.azureFileVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureFileVolumes");
        while (each.hasNext()) {
            AzureFileVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasAzureFileVolumes() {
        return this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty();
    }

    public A addNewAzureFileVolume(String volumeName, String shareName, String secretName, Boolean readOnly) {
        return this.addToAzureFileVolumes(new AzureFileVolume(volumeName, shareName, secretName, readOnly));
    }

    public AzureFileVolumesNested<A> addNewAzureFileVolume() {
        return new AzureFileVolumesNested(-1, null);
    }

    public AzureFileVolumesNested<A> addNewAzureFileVolumeLike(AzureFileVolume item) {
        return new AzureFileVolumesNested(-1, item);
    }

    public AzureFileVolumesNested<A> setNewAzureFileVolumeLike(int index, AzureFileVolume item) {
        return new AzureFileVolumesNested(index, item);
    }

    public AzureFileVolumesNested<A> editAzureFileVolume(int index) {
        if (this.azureFileVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureFileVolumes. Index exceeds size.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    public AzureFileVolumesNested<A> editFirstAzureFileVolume() {
        if (this.azureFileVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(0, this.buildAzureFileVolume(0));
    }

    public AzureFileVolumesNested<A> editLastAzureFileVolume() {
        int index = this.azureFileVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    public AzureFileVolumesNested<A> editMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureFileVolumes.size(); ++i) {
            if (!predicate.test(this.azureFileVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureFileVolumes. No match found.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
            this._visitables.remove((Object)"containers");
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)((Object)this);
    }

    public Container[] buildContainers() {
        int size = this.containers != null ? this.containers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.containers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    public Container buildContainer(int index) {
        return this.containers.get(index).build();
    }

    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A addToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").add(index, builder);
            this.containers.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToContainers(int index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this.containers.size()) {
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        } else {
            this._visitables.get((Object)"containers").set(index, builder);
            this.containers.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromContainers(Container ... items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove((Object)builder);
            this.containers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromContainers(Collection<Container> items) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove((Object)builder);
            this.containers.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)((Object)this);
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    public ContainersNested<A> addNewContainer() {
        return new ContainersNested(-1, null);
    }

    public ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNested(-1, item);
    }

    public ContainersNested<A> setNewContainerLike(int index, Container item) {
        return new ContainersNested(index, item);
    }

    public ContainersNested<A> editContainer(int index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    public ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JobFluent that = (JobFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.parallelism, that.parallelism)) {
            return false;
        }
        if (!Objects.equals(this.completions, that.completions)) {
            return false;
        }
        if (!Objects.equals((Object)this.completionMode, (Object)that.completionMode)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimit, that.backoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        if (!Objects.equals((Object)this.restartPolicy, (Object)that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.pvcVolumes, that.pvcVolumes)) {
            return false;
        }
        if (!Objects.equals(this.secretVolumes, that.secretVolumes)) {
            return false;
        }
        if (!Objects.equals(this.configMapVolumes, that.configMapVolumes)) {
            return false;
        }
        if (!Objects.equals(this.emptyDirVolumes, that.emptyDirVolumes)) {
            return false;
        }
        if (!Objects.equals(this.awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureDiskVolumes, that.azureDiskVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureFileVolumes, that.azureFileVolumes)) {
            return false;
        }
        return Objects.equals(this.containers, that.containers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.parallelism, this.completions, this.completionMode, this.backoffLimit, this.activeDeadlineSeconds, this.ttlSecondsAfterFinished, this.suspend, this.restartPolicy, this.pvcVolumes, this.secretVolumes, this.configMapVolumes, this.emptyDirVolumes, this.awsElasticBlockStoreVolumes, this.azureDiskVolumes, this.azureFileVolumes, this.containers, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.parallelism != null) {
            sb.append("parallelism:");
            sb.append(this.parallelism + ",");
        }
        if (this.completions != null) {
            sb.append("completions:");
            sb.append(this.completions + ",");
        }
        if (this.completionMode != null) {
            sb.append("completionMode:");
            sb.append((Object)((Object)this.completionMode) + ",");
        }
        if (this.backoffLimit != null) {
            sb.append("backoffLimit:");
            sb.append(this.backoffLimit + ",");
        }
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.ttlSecondsAfterFinished != null) {
            sb.append("ttlSecondsAfterFinished:");
            sb.append(this.ttlSecondsAfterFinished + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append((Object)((Object)this.restartPolicy) + ",");
        }
        if (this.pvcVolumes != null) {
            sb.append("pvcVolumes:");
            sb.append(this.pvcVolumes + ",");
        }
        if (this.secretVolumes != null) {
            sb.append("secretVolumes:");
            sb.append(this.secretVolumes + ",");
        }
        if (this.configMapVolumes != null) {
            sb.append("configMapVolumes:");
            sb.append(this.configMapVolumes + ",");
        }
        if (this.emptyDirVolumes != null) {
            sb.append("emptyDirVolumes:");
            sb.append(this.emptyDirVolumes + ",");
        }
        if (this.awsElasticBlockStoreVolumes != null) {
            sb.append("awsElasticBlockStoreVolumes:");
            sb.append(this.awsElasticBlockStoreVolumes + ",");
        }
        if (this.azureDiskVolumes != null) {
            sb.append("azureDiskVolumes:");
            sb.append(this.azureDiskVolumes + ",");
        }
        if (this.azureFileVolumes != null) {
            sb.append("azureFileVolumes:");
            sb.append(this.azureFileVolumes + ",");
        }
        if (this.containers != null) {
            sb.append("containers:");
            sb.append(this.containers);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSuspend() {
        return this.withSuspend(true);
    }

    public class ContainersNested<N>
    extends ContainerFluent<ContainersNested<N>>
    implements Nested<N> {
        ContainerBuilder builder;
        int index;

        ContainersNested(int index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToContainers(this.index, this.builder.build());
        }

        public N endContainer() {
            return this.and();
        }
    }

    public class AzureFileVolumesNested<N>
    extends AzureFileVolumeFluent<AzureFileVolumesNested<N>>
    implements Nested<N> {
        AzureFileVolumeBuilder builder;
        int index;

        AzureFileVolumesNested(int index, AzureFileVolume item) {
            this.index = index;
            this.builder = new AzureFileVolumeBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToAzureFileVolumes(this.index, this.builder.build());
        }

        public N endAzureFileVolume() {
            return this.and();
        }
    }

    public class AzureDiskVolumesNested<N>
    extends AzureDiskVolumeFluent<AzureDiskVolumesNested<N>>
    implements Nested<N> {
        AzureDiskVolumeBuilder builder;
        int index;

        AzureDiskVolumesNested(int index, AzureDiskVolume item) {
            this.index = index;
            this.builder = new AzureDiskVolumeBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToAzureDiskVolumes(this.index, this.builder.build());
        }

        public N endAzureDiskVolume() {
            return this.and();
        }
    }

    public class AwsElasticBlockStoreVolumesNested<N>
    extends AwsElasticBlockStoreVolumeFluent<AwsElasticBlockStoreVolumesNested<N>>
    implements Nested<N> {
        AwsElasticBlockStoreVolumeBuilder builder;
        int index;

        AwsElasticBlockStoreVolumesNested(int index, AwsElasticBlockStoreVolume item) {
            this.index = index;
            this.builder = new AwsElasticBlockStoreVolumeBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToAwsElasticBlockStoreVolumes(this.index, this.builder.build());
        }

        public N endAwsElasticBlockStoreVolume() {
            return this.and();
        }
    }

    public class EmptyDirVolumesNested<N>
    extends EmptyDirVolumeFluent<EmptyDirVolumesNested<N>>
    implements Nested<N> {
        EmptyDirVolumeBuilder builder;
        int index;

        EmptyDirVolumesNested(int index, EmptyDirVolume item) {
            this.index = index;
            this.builder = new EmptyDirVolumeBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToEmptyDirVolumes(this.index, this.builder.build());
        }

        public N endEmptyDirVolume() {
            return this.and();
        }
    }

    public class ConfigMapVolumesNested<N>
    extends ConfigMapVolumeFluent<ConfigMapVolumesNested<N>>
    implements Nested<N> {
        ConfigMapVolumeBuilder builder;
        int index;

        ConfigMapVolumesNested(int index, ConfigMapVolume item) {
            this.index = index;
            this.builder = new ConfigMapVolumeBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToConfigMapVolumes(this.index, this.builder.build());
        }

        public N endConfigMapVolume() {
            return this.and();
        }
    }

    public class SecretVolumesNested<N>
    extends SecretVolumeFluent<SecretVolumesNested<N>>
    implements Nested<N> {
        SecretVolumeBuilder builder;
        int index;

        SecretVolumesNested(int index, SecretVolume item) {
            this.index = index;
            this.builder = new SecretVolumeBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToSecretVolumes(this.index, this.builder.build());
        }

        public N endSecretVolume() {
            return this.and();
        }
    }

    public class PvcVolumesNested<N>
    extends PersistentVolumeClaimVolumeFluent<PvcVolumesNested<N>>
    implements Nested<N> {
        PersistentVolumeClaimVolumeBuilder builder;
        int index;

        PvcVolumesNested(int index, PersistentVolumeClaimVolume item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimVolumeBuilder(this, item);
        }

        public N and() {
            return (N)JobFluent.this.setToPvcVolumes(this.index, this.builder.build());
        }

        public N endPvcVolume() {
            return this.and();
        }
    }
}

