/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Quantity;

public class ApplyLimitsMemoryDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private static final String MEM = "memory";
    private final String amount;

    public ApplyLimitsMemoryDecorator(String containerName, String amount) {
        super(containerName);
        this.amount = amount;
    }

    public ApplyLimitsMemoryDecorator(String deploymentName, String containerName, String amount) {
        super(deploymentName, containerName);
        this.amount = amount;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        ((ContainerFluent.ResourcesNested)container.editOrNewResources().addToLimits(MEM, new Quantity(this.amount))).endResources();
    }
}

