/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.apt;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.processor.AbstractAnnotationProcessor;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@Description(value="Generates kubernetes manifests.")
@SupportedAnnotationTypes(value={"io.dekorate.kubernetes.annotation.KubernetesApplication"})
public class KubernetesAnnotationProcessor
extends AbstractAnnotationProcessor {
    private final Logger LOGGER = LoggerFactory.getLogger();

    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.getSession().close();
            return true;
        }
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                this.LOGGER.info("Found @KubernetesApplication on: " + element.toString());
                this.process("kubernetes", element, KubernetesApplication.class);
            }
        }
        return false;
    }
}

