/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddCommitIdAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddVcsUrlAnnotationDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

@Description(value="Remove an annotation from the matching resources (filtered by name and/or kinds).")
public class RemoveAnnotationDecorator
extends NamedResourceDecorator<ObjectMetaBuilder> {
    private final String annotationKey;

    public RemoveAnnotationDecorator(String annotationKey) {
        this(ANY, annotationKey);
    }

    public RemoveAnnotationDecorator(String name, String annotationKey) {
        super(name);
        this.annotationKey = annotationKey;
    }

    @Override
    public void andThenVisit(ObjectMetaBuilder builder, ObjectMeta resourceMeta) {
        builder.removeFromAnnotations(this.annotationKey);
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, AddAnnotationDecorator.class, AddVcsUrlAnnotationDecorator.class, AddCommitIdAnnotationDecorator.class};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationKey == null ? 0 : this.annotationKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoveAnnotationDecorator other = (RemoveAnnotationDecorator)obj;
        return !(this.annotationKey == null ? other.annotationKey != null : !this.annotationKey.equals(other.annotationKey));
    }
}

