/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.decorator.AddRouteDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.RouteSpecFluent;
import java.util.Arrays;
import java.util.List;

@Description(value="Add the host to the Route resource.")
public class AddHostToRouteDecorator
extends NamedResourceDecorator<RouteSpecFluent<?>>
implements WithConfigReferences {
    private final OpenshiftConfig config;

    public AddHostToRouteDecorator(OpenshiftConfig config) {
        super("Route", config.getName());
        this.config = config;
    }

    public void andThenVisit(RouteSpecFluent<?> spec, ObjectMeta resourceMeta) {
        if (!spec.hasHost() && this.config.getRoute() != null && Strings.isNotNullOrEmpty((String)this.config.getRoute().getHost())) {
            spec.withHost(this.config.getRoute().getHost());
        }
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{AddRouteDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceHost());
    }

    private ConfigReference buildConfigReferenceHost() {
        String property = "host";
        String path = "(kind == Route && metadata.name == " + this.getName() + ").spec.host";
        return new ConfigReference.Builder(property, path).withDescription("The host under which the application is going to be exposed.").build();
    }
}

