/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.buildservice;

import io.dekorate.BuildService;
import io.dekorate.DekorateException;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.Secret;
import io.dekorate.deps.kubernetes.client.dsl.Deletable;
import io.dekorate.deps.kubernetes.client.dsl.FilterWatchListDeletable;
import io.dekorate.deps.openshift.api.model.Build;
import io.dekorate.deps.openshift.api.model.BuildConfig;
import io.dekorate.deps.openshift.api.model.BuildList;
import io.dekorate.deps.openshift.api.model.ImageStream;
import io.dekorate.deps.openshift.client.DefaultOpenShiftClient;
import io.dekorate.deps.openshift.client.OpenShiftClient;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.s2i.util.S2iUtils;
import io.dekorate.utils.Exec;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public class S2iBuildService
implements BuildService {
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final Exec.ProjectExec exec;
    private final Project project;
    private final ImageConfiguration config;
    private final Collection<HasMetadata> resources;

    public S2iBuildService(Project project, ImageConfiguration config, Collection<HasMetadata> resources) {
        this.project = project;
        this.config = config;
        this.resources = resources;
        this.exec = Exec.inProject((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try (DefaultOpenShiftClient client = new DefaultOpenShiftClient();){
            Thread.currentThread().setContextClassLoader(S2iBuildService.class.getClassLoader());
            BuildList builds = (BuildList)((FilterWatchListDeletable)client.builds().withLabel("openshift.io/build-config.name", S2iBuildService.buildConfigName(this.resources))).list();
            builds.getItems().stream().forEach(arg_0 -> this.lambda$prepare$0((OpenShiftClient)client, arg_0));
            this.resources.stream().filter(i -> i instanceof BuildConfig || i instanceof ImageStream || i instanceof Secret).forEach(arg_0 -> this.lambda$prepare$3((OpenShiftClient)client, arg_0));
            S2iUtils.waitForImageStreamTags(this.resources, 2L, TimeUnit.MINUTES);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public void build() {
        if (!this.project.getBuildInfo().getOutputFile().getParent().toFile().exists()) {
            throw new IllegalStateException("Can't trigger binary build. " + this.project.getBuildInfo().getOutputFile().toAbsolutePath().toString() + " does not exist!");
        }
        this.LOGGER.info("Performing s2i build.");
        this.exec.commands(new String[]{"oc", "start-build", S2iBuildService.buildConfigName(this.resources), "--from-dir=" + this.project.getBuildInfo().getOutputFile().getParent().toAbsolutePath().toString(), "--follow"});
    }

    public void push() {
    }

    private static String buildConfigName(Collection<HasMetadata> resources) {
        return resources.stream().filter(h -> "BuildConfig".equals(h.getKind())).map(h -> h.getMetadata().getName()).findFirst().orElseThrow(() -> new IllegalStateException("No build config found."));
    }

    private /* synthetic */ void lambda$prepare$3(OpenShiftClient client, HasMetadata i) {
        if (i instanceof BuildConfig) {
            ((Deletable)client.resource(i).cascading(true)).delete();
            try {
                client.resource(i).waitUntilCondition(d -> d == null, 10L, TimeUnit.SECONDS);
            }
            catch (IllegalArgumentException e) {
                this.LOGGER.warning(e.getMessage());
            }
            catch (InterruptedException e) {
                this.LOGGER.warning(e.getMessage());
                throw DekorateException.launderThrowable((Throwable)e);
            }
        }
        client.resource(i).createOrReplace();
        this.LOGGER.info("Applied: " + i.getKind() + " " + i.getMetadata().getName());
    }

    private /* synthetic */ void lambda$prepare$0(OpenShiftClient client, Build b) {
        this.LOGGER.info("Deleting stale build:" + b.getMetadata().getName());
        ((Deletable)client.resource((HasMetadata)b).cascading(true)).delete();
    }
}

