/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.decorator;

import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.ObjectMeta;
import io.dekorate.deps.openshift.api.model.ImageStreamBuilder;
import io.dekorate.deps.openshift.api.model.ImageStreamFluent;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;

@Description(value="Add a output ImageStream resource to the list of generated resources.")
public class AddDockerImageStreamResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final ImageConfiguration config;
    private final String dockerImageRepository;

    public AddDockerImageStreamResourceDecorator(ImageConfiguration config, String dockerImageRepository) {
        this.config = config;
        this.dockerImageRepository = dockerImageRepository;
    }

    public void visit(KubernetesListBuilder list) {
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list);
        if (this.contains(list, "image.openshift.io/v1", "ImageStream", this.config.getName())) {
            return;
        }
        list.addToItems((VisitableBuilder)((ImageStreamFluent.SpecNested)((ImageStreamBuilder)((ImageStreamFluent.MetadataNested)((ImageStreamFluent.MetadataNested)new ImageStreamBuilder().withNewMetadata().withName(this.config.getName())).withLabels(meta.getLabels())).endMetadata()).withNewSpec().withDockerImageRepository(this.dockerImageRepository)).endSpec());
    }
}

