/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.s2i.generator;

import io.dekorate.Generator;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Session;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.kubernetes.configurator.ApplyBuildToImageConfiguration;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.s2i.adapter.S2iBuildConfigAdapter;
import io.dekorate.s2i.annotation.S2iBuild;
import io.dekorate.s2i.config.S2iBuildConfig;
import io.dekorate.s2i.config.S2iBuildConfigBuilder;
import io.dekorate.s2i.handler.S2iHanlder;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.Element;

public interface S2iBuildGenerator
extends Generator,
WithSession,
WithProject {
    public static final String S2I = "s2i";

    default public String getKey() {
        return S2I;
    }

    default public Class<? extends Annotation> getAnnotation() {
        return S2iBuild.class;
    }

    default public void add(Map map) {
        this.on((ConfigurationSupplier<S2iBuildConfig>)new PropertyConfiguration((VisitableBuilder)((S2iBuildConfigBuilder)S2iBuildConfigAdapter.newBuilder(this.propertiesMap(map, S2iBuild.class)).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(Element element) {
        S2iBuild enableS2iBuild = element.getAnnotation(S2iBuild.class);
        this.on((ConfigurationSupplier<S2iBuildConfig>)(enableS2iBuild != null ? new AnnotationConfiguration((VisitableBuilder)((S2iBuildConfigBuilder)S2iBuildConfigAdapter.newBuilder(enableS2iBuild).accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))) : new AnnotationConfiguration((VisitableBuilder)((S2iBuildConfigBuilder)new S2iBuildConfigBuilder().accept((Visitor)new ApplyBuildToImageConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject())))));
    }

    default public void on(ConfigurationSupplier<S2iBuildConfig> config) {
        Logger log = LoggerFactory.getLogger();
        Session session = this.getSession();
        session.configurators().add(config);
        session.handlers().add(new S2iHanlder(session.resources(), session.configurators()));
    }
}

