/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.params;

import io.dropwizard.jersey.errors.ErrorMessage;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractParam<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractParam.class);
    private final T value;

    protected AbstractParam(String input) {
        try {
            this.value = this.parse(input);
        }
        catch (Exception e) {
            throw new WebApplicationException(this.error(input, e));
        }
    }

    protected Response error(String input, Exception e) {
        LOGGER.debug("Invalid input received: {}", (Object)input);
        return Response.status((Response.Status)this.getErrorStatus()).entity((Object)new ErrorMessage(this.getErrorStatus().getStatusCode(), this.errorMessage(e))).type(this.mediaType()).build();
    }

    protected MediaType mediaType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }

    protected String errorMessage(Exception e) {
        return String.format("Invalid parameter: %s", e.getMessage());
    }

    protected Response.Status getErrorStatus() {
        return Response.Status.BAD_REQUEST;
    }

    protected abstract T parse(String var1) throws Exception;

    public T get() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractParam that = (AbstractParam)obj;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }
}

