/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalDouble;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalDoubleParamConverterProvider
implements ParamConverterProvider {
    private final OptionalDoubleParamConverter paramConverter = new OptionalDoubleParamConverter();

    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        return OptionalDouble.class.equals(rawType) ? this.paramConverter : null;
    }

    public static class OptionalDoubleParamConverter
    implements ParamConverter<OptionalDouble> {
        public OptionalDouble fromString(String value) {
            try {
                double d = Double.parseDouble(value);
                return OptionalDouble.of(d);
            }
            catch (NumberFormatException e) {
                return OptionalDouble.empty();
            }
        }

        public String toString(OptionalDouble value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            return value.isPresent() ? Double.toString(value.getAsDouble()) : "";
        }
    }
}

