/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import javax.inject.Singleton;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalIntParamConverterProvider
implements ParamConverterProvider {
    private final OptionalIntParamConverter paramConverter = new OptionalIntParamConverter();

    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        return OptionalInt.class.equals(rawType) ? this.paramConverter : null;
    }

    public static class OptionalIntParamConverter
    implements ParamConverter<OptionalInt> {
        public OptionalInt fromString(String value) {
            try {
                int i = Integer.parseInt(value);
                return OptionalInt.of(i);
            }
            catch (NumberFormatException e) {
                return OptionalInt.empty();
            }
        }

        public String toString(OptionalInt value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            return value.isPresent() ? Integer.toString(value.getAsInt()) : "";
        }
    }
}

