/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient5;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.socket.ConnectionSocketFactory;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;

public class InstrumentedHttpClientConnectionManager
extends PoolingHttpClientConnectionManager {
    private static final String METRICS_PREFIX = HttpClientConnectionManager.class.getName();
    private final MetricRegistry metricsRegistry;
    private final String name;

    protected static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register(URIScheme.HTTP.id, (Object)PlainConnectionSocketFactory.getSocketFactory()).register(URIScheme.HTTPS.id, (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    }

    InstrumentedHttpClientConnectionManager(MetricRegistry metricRegistry, String name, HttpClientConnectionOperator httpClientConnectionOperator, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive, HttpConnectionFactory<ManagedHttpClientConnection> connFactory) {
        super(httpClientConnectionOperator, poolConcurrencyPolicy, poolReusePolicy, timeToLive, connFactory);
        this.metricsRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
        this.name = name;
        metricRegistry.registerGauge(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "available-connections"}), () -> this.getTotalStats().getAvailable());
        metricRegistry.registerGauge(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "leased-connections"}), () -> this.getTotalStats().getLeased());
        metricRegistry.registerGauge(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "max-connections"}), () -> this.getTotalStats().getMax());
        metricRegistry.registerGauge(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{name, "pending-connections"}), () -> this.getTotalStats().getPending());
    }

    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    public void close(CloseMode closeMode) {
        super.close(closeMode);
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "available-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "leased-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "max-connections"}));
        this.metricsRegistry.remove(MetricRegistry.name((String)METRICS_PREFIX, (String[])new String[]{this.name, "pending-connections"}));
    }

    public static Builder builder(MetricRegistry metricsRegistry) {
        return new Builder().metricsRegistry(metricsRegistry);
    }

    public static class Builder {
        private MetricRegistry metricsRegistry;
        private String name;
        private HttpClientConnectionOperator httpClientConnectionOperator;
        private Registry<ConnectionSocketFactory> socketFactoryRegistry = InstrumentedHttpClientConnectionManager.getDefaultRegistry();
        private SchemePortResolver schemePortResolver;
        private DnsResolver dnsResolver;
        private PoolConcurrencyPolicy poolConcurrencyPolicy;
        private PoolReusePolicy poolReusePolicy;
        private TimeValue timeToLive = TimeValue.NEG_ONE_MILLISECOND;
        private HttpConnectionFactory<ManagedHttpClientConnection> connFactory;

        Builder() {
        }

        public Builder metricsRegistry(MetricRegistry metricRegistry) {
            this.metricsRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder socketFactoryRegistry(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
            this.socketFactoryRegistry = Objects.requireNonNull(socketFactoryRegistry, "socketFactoryRegistry");
            return this;
        }

        public Builder connFactory(HttpConnectionFactory<ManagedHttpClientConnection> connFactory) {
            this.connFactory = connFactory;
            return this;
        }

        public Builder schemePortResolver(SchemePortResolver schemePortResolver) {
            this.schemePortResolver = schemePortResolver;
            return this;
        }

        public Builder dnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver = dnsResolver;
            return this;
        }

        public Builder timeToLive(TimeValue timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public Builder httpClientConnectionOperator(HttpClientConnectionOperator httpClientConnectionOperator) {
            this.httpClientConnectionOperator = httpClientConnectionOperator;
            return this;
        }

        public Builder poolConcurrencyPolicy(PoolConcurrencyPolicy poolConcurrencyPolicy) {
            this.poolConcurrencyPolicy = poolConcurrencyPolicy;
            return this;
        }

        public Builder poolReusePolicy(PoolReusePolicy poolReusePolicy) {
            this.poolReusePolicy = poolReusePolicy;
            return this;
        }

        public InstrumentedHttpClientConnectionManager build() {
            if (this.httpClientConnectionOperator == null) {
                this.httpClientConnectionOperator = new DefaultHttpClientConnectionOperator(this.socketFactoryRegistry, this.schemePortResolver, this.dnsResolver);
            }
            return new InstrumentedHttpClientConnectionManager(this.metricsRegistry, this.name, this.httpClientConnectionOperator, this.poolConcurrencyPolicy, this.poolReusePolicy, this.timeToLive, this.connFactory);
        }
    }
}

